/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.properties.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.runtime.properties.api.ResourceProvider;
import org.mule.runtime.properties.internal.ConfigurationPropertiesException;
import org.mule.runtime.properties.internal.DefaultConfigurationProperty;
import org.mule.runtime.properties.internal.YamlFactory;
import org.vibur.objectpool.ConcurrentPool;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.ConcurrentCollection;
import org.vibur.objectpool.util.ConcurrentLinkedQueueCollection;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.parser.ParserException;

public class DefaultConfigurationPropertiesProvider
extends AbstractComponent
implements ConfigurationPropertiesProvider,
Initialisable {
    private static final Pattern SPACE_AFTER_COLON_PATTERN = Pattern.compile("[^:]*: ");
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String YAML_EXTENSION = ".yaml";
    protected static final String UNKNOWN = "unknown";
    private static final PoolService<Yaml> YAML_POOL = new ConcurrentPool((ConcurrentCollection)new ConcurrentLinkedQueueCollection(), (PoolObjectFactory)new YamlFactory(), 1, Math.max(1, Runtime.getRuntime().availableProcessors() / 2), false);
    protected final Map<String, ConfigurationProperty> configurationAttributes = new HashMap<String, ConfigurationProperty>();
    protected final String fileLocation;
    private final String encoding;
    private final ResourceProvider resourceProvider;

    public DefaultConfigurationPropertiesProvider(String fileLocation, String encoding, ResourceProvider resourceProvider) {
        this.fileLocation = fileLocation;
        this.resourceProvider = resourceProvider;
        this.encoding = encoding;
    }

    public DefaultConfigurationPropertiesProvider(String fileLocation, ResourceProvider resourceProvider) {
        this(fileLocation, null, resourceProvider);
    }

    public Optional<ConfigurationProperty> provide(String configurationAttributeKey) {
        return Optional.ofNullable(this.configurationAttributes.get(configurationAttributeKey));
    }

    @Override
    public String getDescription() {
        ComponentLocation location = (ComponentLocation)this.getAnnotation(LOCATION_KEY);
        return String.format("<" + this.getIdentifier().toString() + " file=\"%s\"> - file: %s, line number: %s", this.fileLocation, location.getFileName().orElse(UNKNOWN), location.getLine().orElse(-1));
    }

    protected InputStream getResourceInputStream(String file) throws IOException {
        return this.resourceProvider.getResourceAsStream(file);
    }

    private InputStreamReader getResourceInputStreamReader(String file) throws IOException {
        InputStream in = this.getResourceInputStream(file);
        return this.encoding != null ? new InputStreamReader(in, this.encoding) : new InputStreamReader(in);
    }

    public void initialise() throws InitialisationException {
        if (!this.fileLocation.endsWith(PROPERTIES_EXTENSION) && !this.fileLocation.endsWith(YAML_EXTENSION)) {
            throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage((String)String.format("Configuration properties file %s must end with yaml or properties extension", this.fileLocation)), (Component)this);
        }
        try (BufferedReader is = new BufferedReader(this.getResourceInputStreamReader(this.fileLocation));){
            if (is == null) {
                throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage((String)String.format("Couldn't find configuration properties file %s neither on classpath or in file system", this.fileLocation)), (Component)this);
            }
            this.readAttributesFromFile(is);
        }
        catch (ConfigurationPropertiesException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage((String)("Couldn't read from file " + this.fileLocation + ": " + e.getMessage())), (Component)this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAttributesFromFile(Reader is) throws IOException {
        if (this.fileLocation.endsWith(PROPERTIES_EXTENSION)) {
            Properties properties = new Properties();
            properties.load(is);
            properties.keySet().stream().map(key -> new DefaultConfigurationProperty(Optional.of(this), (String)key, this.createValue((String)key, (String)properties.get(key)))).forEach(configurationAttribute -> this.configurationAttributes.put(configurationAttribute.getKey(), (ConfigurationProperty)configurationAttribute));
        } else {
            Yaml yaml = (Yaml)YAML_POOL.take();
            try {
                Iterable yamlObjects = yaml.loadAll(is);
                try {
                    yamlObjects.forEach(yamlObject -> this.createAttributesFromYamlObject(null, null, yamlObject));
                }
                catch (ParserException e) {
                    throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage((String)"Error while parsing YAML configuration file. Check that all quotes are correctly closed."), (Component)this, (Exception)((Object)e));
                }
            }
            finally {
                YAML_POOL.restore((Object)yaml);
            }
        }
    }

    private void createAttributesFromYamlObject(String parentPath, Object parentYamlObject, Object yamlObject) {
        if (yamlObject instanceof List) {
            List list = (List)yamlObject;
            if (list.get(0) instanceof Map) {
                list.forEach(value -> this.createAttributesFromYamlObject(parentPath, yamlObject, value));
            } else {
                if (!(list.get(0) instanceof String)) {
                    throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage((String)("List of complex objects are not supported as property values. Offending key is " + parentPath)), (Component)this);
                }
                String[] values = new String[list.size()];
                list.toArray(values);
                String value2 = String.join((CharSequence)",", list);
                this.configurationAttributes.put(parentPath, new DefaultConfigurationProperty(this, parentPath, value2));
            }
        } else if (yamlObject instanceof Map) {
            if (parentYamlObject instanceof List) {
                throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage((String)("Configuration properties does not support type a list of complex types. Complex type keys are: " + String.join((CharSequence)",", ((Map)yamlObject).keySet()))), (Component)this);
            }
            Map map = (Map)yamlObject;
            map.entrySet().stream().forEach(entry -> this.createAttributesFromYamlObject(this.createKey(parentPath, (String)entry.getKey()), yamlObject, entry.getValue()));
        } else {
            if (!(yamlObject instanceof String)) {
                throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage((String)String.format("YAML configuration properties only supports string values, make sure to wrap the value with \" so you force the value to be an string. Offending property is %s with value %s", parentPath, yamlObject)), (Component)this);
            }
            if (parentPath == null) {
                if (!SPACE_AFTER_COLON_PATTERN.matcher((String)yamlObject).matches()) {
                    throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage((String)String.format("YAML configuration properties must have space after ':' character. Offending line is: %s", yamlObject)), (Component)this);
                }
                throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage((String)String.format("YAML configuration property key must not be null. Offending line is %s", yamlObject)), (Component)this);
            }
            String resultObject = this.createValue(parentPath, (String)yamlObject);
            this.configurationAttributes.put(parentPath, new DefaultConfigurationProperty(this, parentPath, resultObject));
        }
    }

    private String createKey(String parentKey, String key) {
        if (parentKey == null) {
            return key;
        }
        return parentKey + "." + key;
    }

    protected String createValue(String key, String value) {
        return value;
    }

    public String toString() {
        return this.getDescription();
    }
}

