/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperation;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationCallback;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultTroubleshootingOperationDefinition;

public class ThreadCpuUsageOperation
implements TroubleshootingOperation {
    public static final String THREAD_CPU_USAGE_OPERATION_NAME = "threadCpuUsage";
    public static final String THREAD_CPU_USAGE_OPERATION_DESCRIPTION = "Collects current CPU usage information for all threads";
    private static final TroubleshootingOperationDefinition definition = ThreadCpuUsageOperation.createOperationDefinition();

    @Override
    public TroubleshootingOperationDefinition getDefinition() {
        return definition;
    }

    @Override
    public TroubleshootingOperationCallback getCallback() {
        return (arguments, writer) -> {
            try {
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                if (!threadMXBean.isThreadCpuTimeSupported()) {
                    writer.write("Thread CPU time measurement is not supported on this JVM" + System.lineSeparator());
                    return;
                }
                if (!threadMXBean.isThreadCpuTimeEnabled()) {
                    threadMXBean.setThreadCpuTimeEnabled(true);
                }
                long[] threadIds = threadMXBean.getAllThreadIds();
                HashMap<Long, Long> firstSnapshot = new HashMap<Long, Long>();
                for (long threadId : threadIds) {
                    long cpuTime = threadMXBean.getThreadCpuTime(threadId);
                    if (cpuTime == -1L) continue;
                    firstSnapshot.put(threadId, cpuTime);
                }
                long sampleMillis = 3000L;
                Thread.sleep(sampleMillis);
                HashMap<Long, Long> secondSnapshot = new HashMap<Long, Long>();
                for (long threadId : threadIds) {
                    long cpuTime = threadMXBean.getThreadCpuTime(threadId);
                    if (cpuTime == -1L) continue;
                    secondSnapshot.put(threadId, cpuTime);
                }
                ArrayList<ThreadCpuInfo> threadCpuInfos = new ArrayList<ThreadCpuInfo>();
                ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(threadIds, 0);
                int cpuCores = Runtime.getRuntime().availableProcessors();
                double elapsedNanos = (double)sampleMillis * 1000000.0;
                for (int i = 0; i < threadIds.length; ++i) {
                    long threadId = threadIds[i];
                    ThreadInfo threadInfo = threadInfos[i];
                    if (threadInfo == null || !firstSnapshot.containsKey(threadId) || !secondSnapshot.containsKey(threadId)) continue;
                    long cpuTimeDiff = (Long)secondSnapshot.get(threadId) - (Long)firstSnapshot.get(threadId);
                    double cpuTimeMs = (double)cpuTimeDiff / 1000000.0;
                    double cpuPercent = (double)cpuTimeDiff / elapsedNanos * 100.0 / (double)cpuCores;
                    threadCpuInfos.add(new ThreadCpuInfo(threadId, threadInfo.getThreadName(), threadInfo.getThreadState().toString(), cpuTimeMs, cpuPercent, (double)((Long)secondSnapshot.get(threadId)).longValue() / 1000000.0));
                }
                ArrayList<ThreadCpuInfo> activeThreads = new ArrayList<ThreadCpuInfo>();
                for (ThreadCpuInfo info : threadCpuInfos) {
                    if (!(info.getCpuPercent() >= 0.005)) continue;
                    activeThreads.add(info);
                }
                activeThreads.sort(Comparator.comparingDouble(ThreadCpuInfo::getCpuUsageMs).reversed());
                writer.write("=== Thread CPU Usage (active threads only, sorted by current consumption) ===" + System.lineSeparator());
                writer.write(String.format(Locale.US, "%-10s %-7s %-60s %-15s %-20s %-20s%n", "Thread ID", "%CPU", "Thread Name", "State", "CPU Time (3s)", "Total CPU Time"));
                writer.write(String.format(Locale.US, "%-10s %-7s %-60s %-15s %-20s %-20s%n", "----------", "-------", "------------------------------------------------------------", "---------------", "--------------------", "--------------------"));
                if (activeThreads.isEmpty()) {
                    writer.write("No threads with significant CPU usage detected during the sampling period." + System.lineSeparator());
                } else {
                    for (ThreadCpuInfo info : activeThreads) {
                        writer.write(String.format(Locale.US, "%-10d %-7.2f %-60s %-15s %-20s %-20s%n", info.getThreadId(), info.getCpuPercent(), this.truncate(info.getThreadName(), 60), this.truncate(info.getState(), 15), this.formatTime(info.getCpuUsageMs()), this.formatTime(info.getTotalCpuTimeMs())));
                    }
                }
                writer.write(System.lineSeparator());
                writer.write("CPU percentage is normalized by the number of CPU cores (" + cpuCores + " cores)." + System.lineSeparator());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get thread CPU usage: " + e.getMessage(), e);
            }
        };
    }

    private static TroubleshootingOperationDefinition createOperationDefinition() {
        return new DefaultTroubleshootingOperationDefinition(THREAD_CPU_USAGE_OPERATION_NAME, THREAD_CPU_USAGE_OPERATION_DESCRIPTION, new ArgumentDefinition[0]);
    }

    private String truncate(String str, int maxLength) {
        if (str == null) {
            return "";
        }
        return str.length() > maxLength ? str.substring(0, maxLength - 3) + "..." : str;
    }

    private String formatTime(double timeMs) {
        if (timeMs < 1000.0) {
            return String.format(Locale.US, "%.2fms", timeMs);
        }
        return String.format(Locale.US, "%.2fs", timeMs / 1000.0);
    }

    private static class ThreadCpuInfo {
        private final long threadId;
        private final String threadName;
        private final String state;
        private final double cpuUsageMs;
        private final double cpuPercent;
        private final double totalCpuTimeMs;

        public ThreadCpuInfo(long threadId, String threadName, String state, double cpuUsageMs, double cpuPercent, double totalCpuTimeMs) {
            this.threadId = threadId;
            this.threadName = threadName;
            this.state = state;
            this.cpuUsageMs = cpuUsageMs;
            this.cpuPercent = cpuPercent;
            this.totalCpuTimeMs = totalCpuTimeMs;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public String getState() {
            return this.state;
        }

        public double getCpuUsageMs() {
            return this.cpuUsageMs;
        }

        public double getCpuPercent() {
            return this.cpuPercent;
        }

        public double getTotalCpuTimeMs() {
            return this.totalCpuTimeMs;
        }
    }
}

