/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.troubleshooting.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperation;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationCallback;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationException;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingService;
import org.mule.runtime.module.troubleshooting.internal.operations.BasicInfoOperation;
import org.mule.runtime.module.troubleshooting.internal.operations.EventDumpOperation;

public class DefaultTroubleshootingService
implements TroubleshootingService {
    private final Map<String, TroubleshootingOperationDefinition> definitionsByName = new HashMap<String, TroubleshootingOperationDefinition>();
    private final Map<String, TroubleshootingOperationCallback> callbacksByName = new LinkedHashMap<String, TroubleshootingOperationCallback>();

    public DefaultTroubleshootingService(DeploymentService deploymentService) {
        this.registerOperation(new BasicInfoOperation());
        this.registerOperation(new EventDumpOperation(deploymentService));
    }

    @Override
    public void registerOperation(TroubleshootingOperation operation) {
        TroubleshootingOperationDefinition definition = operation.getDefinition();
        String operationName = definition.getName();
        this.definitionsByName.put(operationName, definition);
        TroubleshootingOperationCallback callback = operation.getCallback();
        this.callbacksByName.put(operationName, callback);
    }

    @Override
    public void unregisterOperation(String name) {
        this.definitionsByName.remove(name);
        this.callbacksByName.remove(name);
    }

    @Override
    public List<TroubleshootingOperationDefinition> getAvailableOperations() {
        return new ArrayList<TroubleshootingOperationDefinition>(this.definitionsByName.values());
    }

    @Override
    public String executeAllOperations(Map<String, String> arguments) throws TroubleshootingOperationException {
        StringWriter writer = new StringWriter();
        this.writeHeader(writer);
        for (Map.Entry<String, TroubleshootingOperationCallback> callbackEntry : this.callbacksByName.entrySet()) {
            this.doExecuteOperation(callbackEntry.getKey(), arguments, callbackEntry.getValue(), writer);
        }
        return writer.toString();
    }

    @Override
    public String executeOperation(String name, Map<String, String> arguments) throws TroubleshootingOperationException {
        StringWriter writer = new StringWriter();
        this.writeHeader(writer);
        this.doExecuteOperation(name, arguments, this.getCallback(name, arguments), writer);
        return writer.toString();
    }

    private void writeHeader(StringWriter writer) {
        writer.write("Mule Runtime supportability information" + System.lineSeparator());
        writer.write(System.lineSeparator());
        writer.write("  Generated at " + ZonedDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME) + System.lineSeparator());
        writer.write(System.lineSeparator());
    }

    private void doExecuteOperation(String name, Map<String, String> arguments, TroubleshootingOperationCallback callback, StringWriter writer) throws TroubleshootingOperationException {
        String niceName = StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)name), (char)' '));
        writer.write(niceName + System.lineSeparator());
        writer.write(StringUtils.leftPad((String)"", (int)niceName.length(), (String)"=") + System.lineSeparator());
        writer.write(System.lineSeparator());
        try {
            callback.execute(arguments, writer);
        }
        catch (IOException e) {
            throw new TroubleshootingOperationException("Exception executing troubleshooting operation '" + name + ":(" + arguments + ")'", e);
        }
        writer.write(System.lineSeparator());
    }

    private TroubleshootingOperationCallback getCallback(String operationName, Map<String, String> receivedArguments) throws TroubleshootingOperationException {
        TroubleshootingOperationCallback callback = this.callbacksByName.get(operationName);
        TroubleshootingOperationDefinition operationDefinition = this.definitionsByName.get(operationName);
        if (callback == null || operationDefinition == null) {
            throw new TroubleshootingOperationException(String.format("The operation '%s' is not supported or not available", operationName));
        }
        this.checkRequiredParametersArePresent(operationName, receivedArguments, operationDefinition);
        this.checkReceivedArgumentsAreExpected(operationName, receivedArguments, operationDefinition);
        return callback;
    }

    private void checkReceivedArgumentsAreExpected(String operationName, Map<String, String> receivedArguments, TroubleshootingOperationDefinition operationDefinition) throws TroubleshootingOperationException {
        for (String receivedArgument : receivedArguments.keySet()) {
            operationDefinition.getArgumentDefinitions().stream().map(ArgumentDefinition::getName).filter(receivedArgument::equals).findAny().orElseThrow(() -> new TroubleshootingOperationException(String.format("Received unexpected argument '%s' when invoking operation '%s'", receivedArgument, operationName)));
        }
    }

    private void checkRequiredParametersArePresent(String operationName, Map<String, String> receivedArguments, TroubleshootingOperationDefinition operationDefinition) throws TroubleshootingOperationException {
        for (ArgumentDefinition argumentDefinition : operationDefinition.getArgumentDefinitions()) {
            String argumentName = argumentDefinition.getName();
            if (!argumentDefinition.isRequired() || receivedArguments.containsKey(argumentName)) continue;
            throw new TroubleshootingOperationException(String.format("Missing required argument '%s' when invoking operation '%s'", argumentName, operationName));
        }
    }
}

