/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.artifact;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.config.ResolverSetBasedParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.tooling.internal.artifact.params.ExpressionNotSupportedException;
import org.mule.runtime.module.tooling.internal.artifact.params.ParameterExtractor;
import org.mule.runtime.module.tooling.internal.utils.ArtifactHelper;

public class AbstractParameterResolverExecutor {
    protected final MuleContext muleContext;
    protected final ExpressionManager expressionManager;
    protected final ReflectionCache reflectionCache;
    protected final ArtifactHelper artifactHelper;
    public static final String INVALID_PARAMETER_VALUE = "INVALID_PARAMETER_VALUE";

    public AbstractParameterResolverExecutor(MuleContext muleContext, ExpressionManager expressionManager, ReflectionCache reflectionCache, ArtifactHelper artifactHelper) {
        this.muleContext = muleContext;
        this.expressionManager = expressionManager;
        this.reflectionCache = reflectionCache;
        this.artifactHelper = artifactHelper;
    }

    protected ParameterValueResolver parameterValueResolver(ParameterizedElementDeclaration parameterizedElementDeclaration, ParameterizedModel parameterizedModel) throws ExpressionNotSupportedException {
        Map<String, Object> parametersMap = this.parametersMap(parameterizedElementDeclaration, parameterizedModel);
        try {
            ResolverSet resolverSet = ParametersResolver.fromValues(parametersMap, (MuleContext)this.muleContext, (ReflectionCache)this.reflectionCache, (ExpressionManager)this.expressionManager, (String)parameterizedModel.getName()).getParametersAsResolverSet(parameterizedModel, this.muleContext);
            return new ResolverSetBasedParameterResolver(resolverSet, parameterizedModel, this.reflectionCache, this.expressionManager);
        }
        catch (ConfigurationException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error resolving parameters values from declaration"), (Throwable)e);
        }
    }

    protected Map<String, Object> parametersMap(ParameterizedElementDeclaration parameterizedElementDeclaration, ParameterizedModel parameterizedModel) throws ExpressionNotSupportedException {
        HashMap<String, Object> parametersMap = new HashMap<String, Object>();
        Map parameterGroups = parameterizedModel.getParameterGroupModels().stream().collect(Collectors.toMap(NamedObject::getName, Function.identity()));
        for (ParameterGroupElementDeclaration parameterGroupElement : parameterizedElementDeclaration.getParameterGroups()) {
            String parameterGroupName = parameterGroupElement.getName();
            ParameterGroupModel parameterGroupModel = (ParameterGroupModel)parameterGroups.get(parameterGroupName);
            if (parameterGroupModel == null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find parameter group with name: '%s' in model", (Object[])new Object[]{parameterGroupName}));
            }
            for (ParameterElementDeclaration parameterElement : parameterGroupElement.getParameters()) {
                String parameterName = parameterElement.getName();
                ParameterModel parameterModel = (ParameterModel)parameterGroupModel.getParameter(parameterName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find parameter with name: '%s' in parameter group: '%s'", (Object[])new Object[]{parameterName, parameterGroupName})));
                parametersMap.put(parameterName, ParameterExtractor.asDataWeaveExpression(parameterElement.getValue(), parameterModel.getType()));
            }
        }
        return parametersMap;
    }
}

