/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.artifact.metadata;

import java.util.Optional;
import java.util.function.Function;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.internal.metadata.cache.DefaultMetadataCache;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheId;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGenerator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheManager;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.metadata.DefaultMetadataContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.tooling.internal.utils.ArtifactHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetadataExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataExecutor.class);
    protected ConnectionManager connectionManager;
    protected ReflectionCache reflectionCache;
    protected ExpressionManager expressionManager;
    protected ArtifactHelper artifactHelper;
    private MetadataCacheIdGenerator<ElementDeclaration> metadataCacheIdGenerator;
    private MetadataCacheManager metadataCacheManager;

    public MetadataExecutor(ConnectionManager connectionManager, ReflectionCache reflectionCache, ExpressionManager expressionManager, ArtifactHelper artifactHelper, MetadataCacheIdGenerator<ElementDeclaration> metadataCacheIdGenerator, MetadataCacheManager metadataCacheManager) {
        this.connectionManager = connectionManager;
        this.reflectionCache = reflectionCache;
        this.expressionManager = expressionManager;
        this.artifactHelper = artifactHelper;
        this.metadataCacheIdGenerator = metadataCacheIdGenerator;
        this.metadataCacheManager = metadataCacheManager;
    }

    protected Optional<ConfigurationInstance> getConfigurationInstance(ComponentModel componentModel, ComponentElementDeclaration componentElementDeclaration) throws MetadataResolvingException {
        Optional typeResolversInformationModelProperty = componentModel.getModelProperty(TypeResolversInformationModelProperty.class);
        String configRef = componentElementDeclaration.getConfigRef();
        Optional<ConfigurationInstance> optionalConfigurationInstance = Optional.empty();
        if (this.resolverRequiresConfiguration(typeResolversInformationModelProperty, componentModel) && configRef != null && !(optionalConfigurationInstance = this.artifactHelper.getConfigurationInstance(configRef)).isPresent()) {
            throw new MetadataResolvingException(String.format("The resolver requires a configuration but the one referenced by the component declaration with name: '%s' is not present", configRef), FailureCode.COMPONENT_NOT_FOUND);
        }
        return optionalConfigurationInstance;
    }

    protected abstract boolean resolverRequiresConfiguration(Optional<TypeResolversInformationModelProperty> var1, ComponentModel var2);

    private MetadataContext createMetadataContext(Optional<ConfigurationInstance> configurationInstance, ClassLoader extensionClassLoader, MetadataCache metadataCache) {
        return new DefaultMetadataContext(() -> configurationInstance, this.connectionManager, metadataCache, (ClassTypeLoader)new JavaTypeLoader(extensionClassLoader)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <C> Optional<C> getConnection() throws ConnectionException {
                long startTime = System.currentTimeMillis();
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Retrieving connection");
                    }
                    Optional optional = super.getConnection();
                    return optional;
                }
                finally {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Connection retrieved in {}ms", (Object)(System.currentTimeMillis() - startTime));
                    }
                }
            }
        };
    }

    protected <T> MetadataResult<T> runWithMetadataContext(ComponentElementDeclaration componentElementDeclaration, Optional<ConfigurationInstance> configurationInstance, ClassLoader extensionClassLoader, Function<MetadataContext, MetadataResult<T>> contextConsumer) {
        Object metadataContext = null;
        try {
            MetadataCacheId cacheId = this.getMetadataCacheId(componentElementDeclaration);
            MetadataCache metadataCache = this.getOrCreateCache(cacheId.getValue());
            MetadataResult<T> result = contextConsumer.apply(this.createMetadataContext(configurationInstance, extensionClassLoader, metadataCache));
            if (result.isSuccess()) {
                this.updateCache(cacheId.getValue(), metadataCache);
            }
            MetadataResult<T> metadataResult = result;
            return metadataResult;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        finally {
            if (metadataContext != null) {
                metadataContext.dispose();
            }
        }
    }

    private void updateCache(String id, MetadataCache metadataCache) {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Updating MetadataCache entry for id: {}", (Object)id);
            }
            this.metadataCacheManager.updateCache(id, metadataCache);
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't update the MetadataCache due to an internal error, data would be lost and resolvers couldn't share resources between resolutions.", (Throwable)e);
        }
    }

    private MetadataCache getOrCreateCache(String id) {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Creating new MetadataCache with id: {}", (Object)id);
            }
            return this.metadataCacheManager.getOrCreateCache(id);
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't create a MetadataCache due to an internal error, resolvers won't be able to store resources between resolutions. Using an in memory cache.", (Throwable)e);
            return new DefaultMetadataCache();
        }
    }

    private MetadataCacheId getMetadataCacheId(ComponentElementDeclaration componentElementDeclaration) {
        return this.metadataCacheIdGenerator.getIdForGlobalMetadata((Object)componentElementDeclaration).map(id -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ID generated for MetadataCache with value: {}", (Object)id.getParts().toString());
            }
            return id;
        }).orElseThrow(() -> new IllegalStateException(String.format("Missing information to obtain the MetadataCache for the component '%s:%s'", componentElementDeclaration.getDeclaringExtension(), componentElementDeclaration.getName())));
    }

    public void disposeMetadataCache(ComponentElementDeclaration componentElementDeclaration) {
        try {
            String id = this.getMetadataCacheId(componentElementDeclaration).getValue();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Disposing MetadataCache entry for id: {}", (Object)id);
            }
            this.metadataCacheManager.dispose(id);
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't dispose MetadataCache due to an internal error.", (Throwable)e);
        }
    }
}

