/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.connectivity;

import com.google.common.base.Throwables;
import jakarta.inject.Inject;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.exception.ObjectNotFoundException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.internal.context.lazy.NoSuchComponentModelException;

public class LazyConnectivityTestingService
implements ConnectivityTestingService,
Initialisable {
    public static final String NON_LAZY_CONNECTIVITY_TESTING_SERVICE = "_muleNonLazyConnectivityTestingService";
    private final Function<Registry, ConnectivityTestingService> connectivityTestingServiceSupplier;
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;
    @Inject
    private Registry registry;
    private ConnectivityTestingService connectivityTestingService;

    public LazyConnectivityTestingService(Function<Registry, ConnectivityTestingService> connectivityTestingServiceSupplier) {
        this.connectivityTestingServiceSupplier = connectivityTestingServiceSupplier;
    }

    public ConnectionValidationResult testConnection(Location location) {
        try {
            this.lazyComponentInitializer.initializeComponent(location);
        }
        catch (NoSuchComponentModelException e) {
            throw new ObjectNotFoundException(location.toString());
        }
        catch (MuleRuntimeException e) {
            List causalChain = Throwables.getCausalChain((Throwable)e);
            return this.unknownFailureResponse(this.lastMessage(causalChain), (Exception)((Object)e));
        }
        catch (Exception e) {
            return this.unknownFailureResponse(e.getCause().getMessage(), e);
        }
        return this.connectivityTestingService.testConnection(location);
    }

    private ConnectionValidationResult unknownFailureResponse(String message, Exception e) {
        return ConnectionValidationResult.failure((String)message, (Exception)e);
    }

    private String lastMessage(List<Throwable> causalChain) {
        return causalChain.get(causalChain.size() - 1).getMessage();
    }

    public void initialise() throws InitialisationException {
        this.connectivityTestingService = this.connectivityTestingServiceSupplier.apply(this.registry);
    }
}

