/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.boot.tanuki.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import org.mule.runtime.module.reboot.internal.MuleContainer;
import org.mule.runtime.module.reboot.internal.MuleContainerFactory;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

class MuleContainerTanukiWrapperListener
implements WrapperListener {
    private final MuleContainerFactory muleContainerFactory;
    private final Future<Boolean> configurationsReady;
    private final Runnable onStop;
    private MuleContainer muleContainer;

    public MuleContainerTanukiWrapperListener(MuleContainerFactory muleContainerFactory, Future<Boolean> configurationsReady, Runnable onStop) {
        this.muleContainerFactory = muleContainerFactory;
        this.configurationsReady = configurationsReady;
        this.onStop = onStop;
    }

    public Integer start(String[] args) {
        try {
            this.muleContainer = this.muleContainerFactory.create(args);
            this.startWithContainerClassLoader();
            return null;
        }
        catch (Exception e) {
            this.muleContainer = null;
            StringWriter stackWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stackWriter));
            WrapperManager.log((int)5, (String)stackWriter.toString());
            return 1;
        }
    }

    public int stop(int exitCode) {
        try {
            this.onStop.run();
            if (this.muleContainer != null) {
                this.muleContainer.shutdown();
                this.muleContainer = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return exitCode;
    }

    public void controlEvent(int event) {
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop((int)0);
        }
    }

    private void startWithContainerClassLoader() throws Exception {
        List<String> additionalSplashEntries = Arrays.asList(String.format("Wrapper PID: %d", WrapperManager.getWrapperPID()), String.format("Java PID: %d", WrapperManager.getJavaPID()));
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.muleContainer.getClass().getClassLoader());
        try {
            this.muleContainer.start(this.configurationsReady, additionalSplashEntries);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

