/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.core.api.source.scheduler.CronScheduler;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.metadata.api.dsl.DslElementModel;

class ConfigurationBasedElementModelFactory {
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private final Map<ExtensionModel, DslSyntaxResolver> resolvers;
    private ExtensionModel currentExtension;
    private DslSyntaxResolver dsl;

    ConfigurationBasedElementModelFactory(Map<ExtensionModel, DslSyntaxResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public <T> Optional<DslElementModel<T>> create(ComponentConfiguration configuration) {
        return Optional.ofNullable(this.createIdentifiedElement(configuration));
    }

    private DslElementModel createIdentifiedElement(final ComponentConfiguration configuration) {
        final ComponentIdentifier identifier = configuration.getIdentifier();
        Optional<Map.Entry> entry = this.resolvers.entrySet().stream().filter(e -> ((ExtensionModel)e.getKey()).getXmlDslModel().getPrefix().equals(identifier.getNamespace())).findFirst();
        if (!entry.isPresent()) {
            return null;
        }
        this.currentExtension = (ExtensionModel)entry.get().getKey();
        this.dsl = (DslSyntaxResolver)entry.get().getValue();
        final Reference elementModel = new Reference();
        new ExtensionWalker(){

            protected void onConfiguration(ConfigurationModel model) {
                DslElementSyntax elementDsl = ConfigurationBasedElementModelFactory.this.dsl.resolve((NamedObject)model);
                ConfigurationBasedElementModelFactory.this.getIdentifier(elementDsl).filter(elementId -> elementId.equals(identifier)).ifPresent(elementId -> {
                    DslElementModel.Builder builder = DslElementModel.builder().withModel((Object)model).withDsl(elementDsl).withConfig(configuration);
                    ConfigurationBasedElementModelFactory.this.addConnectionProvider(model, ConfigurationBasedElementModelFactory.this.dsl, (DslElementModel.Builder<ConfigurationModel>)builder, configuration);
                    ConfigurationBasedElementModelFactory.this.enrichElementModel(model, elementDsl, configuration, builder);
                    elementModel.set((Object)builder.build());
                    this.stop();
                });
            }

            protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                DslElementSyntax providerDsl = ConfigurationBasedElementModelFactory.this.dsl.resolve((NamedObject)model);
                ConfigurationBasedElementModelFactory.this.getIdentifier(providerDsl).filter(elementId -> elementId.equals(identifier)).ifPresent(elementId -> {
                    elementModel.set(ConfigurationBasedElementModelFactory.this.createConnectionProviderModel(model, providerDsl, configuration));
                    this.stop();
                });
            }

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                this.onComponentModel((ComponentModel)model);
            }

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                this.onComponentModel((ComponentModel)model);
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                this.onComponentModel((ComponentModel)model);
            }

            private void onComponentModel(ComponentModel model) {
                DslElementSyntax elementDsl = ConfigurationBasedElementModelFactory.this.dsl.resolve((NamedObject)model);
                ConfigurationBasedElementModelFactory.this.getIdentifier(elementDsl).filter(elementId -> elementId.equals(identifier)).ifPresent(elementId -> {
                    elementModel.set((Object)ConfigurationBasedElementModelFactory.this.createElementModel(model, elementDsl, configuration).build());
                    this.stop();
                });
            }
        }.walk(this.currentExtension);
        if (elementModel.get() == null) {
            this.resolveBasedOnTypes(configuration).ifPresent(arg_0 -> ((Reference)elementModel).set(arg_0));
        }
        return (DslElementModel)elementModel.get();
    }

    private Optional<DslElementModel<ObjectType>> resolveBasedOnTypes(ComponentConfiguration configuration) {
        return this.currentExtension.getTypes().stream().map(type -> this.resolveBasedOnType((ObjectType)type, configuration, (Deque<String>)new ArrayDeque<String>())).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private void withStackControl(Deque<String> typeResolvingStack, String stackId, Runnable action) {
        if (!typeResolvingStack.contains(stackId)) {
            typeResolvingStack.push(stackId);
            action.run();
            typeResolvingStack.pop();
        }
    }

    private Optional<DslElementModel<ObjectType>> resolveBasedOnType(ObjectType type, ComponentConfiguration configuration, Deque<String> typeResolvingStack) {
        Optional<ComponentIdentifier> elementIdentifier;
        Optional typeDsl = this.dsl.resolve((MetadataType)type);
        if (typeDsl.isPresent() && (elementIdentifier = this.getIdentifier((DslElementSyntax)typeDsl.get())).isPresent() && elementIdentifier.get().equals(configuration.getIdentifier())) {
            DslElementModel.Builder typeBuilder = DslElementModel.builder().withModel((Object)type).withDsl((DslElementSyntax)typeDsl.get()).withConfig(configuration);
            ExtensionMetadataTypeUtils.getId((MetadataType)type).ifPresent(id -> this.withStackControl(typeResolvingStack, (String)id, () -> this.populateObjectFields(type, configuration, (DslElementSyntax)typeDsl.get(), typeBuilder, typeResolvingStack)));
            return Optional.of(typeBuilder.build());
        }
        return Optional.empty();
    }

    private void populateObjectFields(ObjectType type, ComponentConfiguration configuration, DslElementSyntax typeDsl, DslElementModel.Builder typeBuilder, Deque<String> typeResolvingStack) {
        type.getFields().forEach(field -> {
            if (field.getValue() instanceof ObjectType && field.getAnnotation(FlattenedTypeAnnotation.class).isPresent()) {
                ((ObjectType)field.getValue()).getFields().forEach(nested -> {
                    String name = MetadataTypeUtils.getLocalPart((ObjectFieldType)nested);
                    typeDsl.getContainedElement(name).ifPresent(fieldDsl -> nested.getValue().accept(this.getComponentChildVisitor(typeBuilder, configuration, (MetadataType)nested, name, (DslElementSyntax)fieldDsl, ExtensionModelUtils.getDefaultValue((String)name, (MetadataType)field.getValue()), typeResolvingStack)));
                });
            } else {
                String name = MetadataTypeUtils.getLocalPart((ObjectFieldType)field);
                typeDsl.getContainedElement(name).ifPresent(fieldDsl -> field.getValue().accept(this.getComponentChildVisitor(typeBuilder, configuration, (MetadataType)field, name, (DslElementSyntax)fieldDsl, ExtensionModelUtils.getDefaultValue((String)name, (MetadataType)type), typeResolvingStack)));
            }
        });
    }

    private Multimap<ComponentIdentifier, ComponentConfiguration> getNestedComponents(ComponentConfiguration configuration) {
        ArrayListMultimap result = ArrayListMultimap.create();
        configuration.getNestedComponents().forEach(arg_0 -> ConfigurationBasedElementModelFactory.lambda$getNestedComponents$8((Multimap)result, arg_0));
        return result;
    }

    private MetadataTypeVisitor getComponentChildVisitor(final DslElementModel.Builder typeBuilder, final ComponentConfiguration configuration, final MetadataType model, final String name, final DslElementSyntax modelDsl, final Optional<String> defaultValue, final Deque<String> typeResolvingStack) {
        final Map parameters = configuration.getParameters();
        return new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                DslElementModel.Builder elementBuilder = DslElementModel.builder().withModel((Object)model).withDsl(modelDsl);
                Optional<ComponentIdentifier> identifier = ConfigurationBasedElementModelFactory.this.getIdentifier(modelDsl);
                String value = (String)parameters.get(name);
                if (StringUtils.isBlank((CharSequence)value)) {
                    if (identifier.isPresent()) {
                        ComponentConfiguration nested = ConfigurationBasedElementModelFactory.this.getSingleComponentConfiguration(ConfigurationBasedElementModelFactory.this.getNestedComponents(configuration), identifier);
                        if (nested != null && nested.getValue().isPresent() && !StringUtils.isBlank((CharSequence)((CharSequence)nested.getValue().get()))) {
                            value = ((String)nested.getValue().get()).trim();
                        }
                    } else if (defaultValue.isPresent()) {
                        value = (String)defaultValue.get();
                        elementBuilder.isExplicitInDsl(false);
                    }
                }
                if (!StringUtils.isBlank((CharSequence)value)) {
                    typeBuilder.containing(elementBuilder.withValue(value).build());
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                ComponentConfiguration fieldComponent;
                Optional<ComponentIdentifier> identifier = ConfigurationBasedElementModelFactory.this.getIdentifier(modelDsl);
                if (identifier.isPresent() && (fieldComponent = ConfigurationBasedElementModelFactory.this.getSingleComponentConfiguration(ConfigurationBasedElementModelFactory.this.getNestedComponents(configuration), identifier)) != null) {
                    DslElementModel.Builder list = DslElementModel.builder().withModel((Object)model).withDsl(modelDsl).withConfig(fieldComponent);
                    modelDsl.getGeneric(arrayType.getType()).ifPresent(itemdsl -> {
                        ComponentIdentifier itemIdentifier = ConfigurationBasedElementModelFactory.this.getIdentifier((DslElementSyntax)itemdsl).get();
                        fieldComponent.getNestedComponents().forEach(c -> {
                            if (c.getIdentifier().equals(itemIdentifier)) {
                                ConfigurationBasedElementModelFactory.this.getComponentChildVisitor(list, (ComponentConfiguration)c, arrayType.getType(), "value", (DslElementSyntax)itemdsl, defaultValue, typeResolvingStack);
                            }
                        });
                    });
                    typeBuilder.containing(list.build());
                    return;
                }
                defaultValue.ifPresent(s -> typeBuilder.containing(DslElementModel.builder().withModel((Object)model).withDsl(modelDsl).withValue((String)defaultValue.get()).isExplicitInDsl(false).build()));
            }

            public void visitObject(ObjectType objectType) {
                Optional<ComponentIdentifier> identifier = ConfigurationBasedElementModelFactory.this.getIdentifier(modelDsl);
                if (identifier.isPresent()) {
                    ComponentConfiguration fieldComponent = ConfigurationBasedElementModelFactory.this.getSingleComponentConfiguration(ConfigurationBasedElementModelFactory.this.getNestedComponents(configuration), identifier);
                    if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                        typeBuilder.containing(ConfigurationBasedElementModelFactory.this.createMapElement(objectType, modelDsl, fieldComponent));
                        return;
                    }
                    String value = (String)(fieldComponent = fieldComponent == null ? configuration : fieldComponent).getParameters().get(modelDsl.getAttributeName());
                    if (!StringUtils.isBlank((CharSequence)value)) {
                        typeBuilder.containing(DslElementModel.builder().withModel((Object)model).withDsl(modelDsl).withValue(value).build());
                    } else {
                        ConfigurationBasedElementModelFactory.this.resolveBasedOnType(objectType, fieldComponent, typeResolvingStack).ifPresent(arg_0 -> ((DslElementModel.Builder)typeBuilder).containing(arg_0));
                    }
                    return;
                }
                defaultValue.ifPresent(s -> typeBuilder.containing(DslElementModel.builder().withModel((Object)model).withDsl(modelDsl).withValue((String)defaultValue.get()).isExplicitInDsl(false).build()));
            }
        };
    }

    private DslElementModel createMapElement(ObjectType objectType, DslElementSyntax modelDsl, ComponentConfiguration configuration) {
        DslElementModel.Builder mapBuilder = DslElementModel.builder().withModel((Object)objectType).withDsl(modelDsl).withConfig(configuration);
        if (configuration != null && !configuration.getNestedComponents().isEmpty()) {
            this.populateMapEntries(objectType, modelDsl, mapBuilder, configuration);
        }
        return mapBuilder.build();
    }

    private void populateMapEntries(ObjectType objectType, DslElementSyntax modelDsl, DslElementModel.Builder mapBuilder, ComponentConfiguration mapConfig) {
        mapConfig.getNestedComponents().forEach(entryConfig -> {
            MetadataType entryType = (MetadataType)objectType.getOpenRestriction().get();
            modelDsl.getGeneric(entryType).ifPresent(entryDsl -> {
                DslElementModel.Builder entry = DslElementModel.builder().withModel((Object)entryType).withConfig(entryConfig).withDsl(entryDsl);
                entry.containing(DslElementModel.builder().withModel((Object)this.typeLoader.load(String.class)).withValue((String)entryConfig.getParameters().get("key")).withDsl((DslElementSyntax)entryDsl.getAttribute("key").get()).build());
                String value = (String)entryConfig.getParameters().get("value");
                if (StringUtils.isBlank((CharSequence)value)) {
                    this.getComponentChildVisitor(entry, (ComponentConfiguration)entryConfig, entryType, "value", (DslElementSyntax)entryDsl.getAttribute("value").get(), Optional.empty(), (Deque<String>)new ArrayDeque<String>());
                } else {
                    entry.containing(DslElementModel.builder().withModel((Object)this.typeLoader.load(String.class)).withValue(value).withDsl((DslElementSyntax)entryDsl.getAttribute("value").get()).build());
                }
                mapBuilder.containing(entry.build());
            });
        });
    }

    private DslElementModel<ConnectionProviderModel> createConnectionProviderModel(ConnectionProviderModel providerModel, DslElementSyntax providerDsl, ComponentConfiguration providerConfig) {
        return this.createElementModel(providerModel, providerDsl, providerConfig).build();
    }

    private DslElementModel.Builder<ConfigurationModel> addConnectionProvider(ConfigurationModel model, DslSyntaxResolver dsl, DslElementModel.Builder<ConfigurationModel> element, ComponentConfiguration configuration) {
        Stream.concat(model.getConnectionProviders().stream(), this.currentExtension.getConnectionProviders().stream()).map(provider -> {
            DslElementSyntax providerDsl = dsl.resolve((NamedObject)provider);
            ComponentIdentifier identifier = this.getIdentifier(providerDsl).orElse(null);
            return configuration.getNestedComponents().stream().filter(c -> c.getIdentifier().equals(identifier)).findFirst().map(providerConfig -> element.containing(this.createConnectionProviderModel((ConnectionProviderModel)provider, providerDsl, (ComponentConfiguration)providerConfig)).build()).orElse(null);
        }).filter(Objects::nonNull).findFirst();
        return element;
    }

    private <T extends ParameterizedModel> DslElementModel.Builder<T> createElementModel(T model, DslElementSyntax elementDsl, ComponentConfiguration configuration) {
        DslElementModel.Builder builder = DslElementModel.builder();
        builder.withModel(model).withDsl(elementDsl).withConfig(configuration);
        this.enrichElementModel(model, elementDsl, configuration, builder);
        return builder;
    }

    private <T extends ParameterizedModel> void enrichElementModel(T model, DslElementSyntax elementDsl, ComponentConfiguration configuration, DslElementModel.Builder<T> builder) {
        this.populateParameterizedElements(model, elementDsl, builder, configuration);
        if (model instanceof ComposableModel) {
            this.populateComposableElements((ComposableModel)model, elementDsl, builder, configuration);
        }
        if (model instanceof SourceModel) {
            ((SourceModel)model).getSuccessCallback().ifPresent(cb -> this.populateParameterizedElements((ParameterizedModel)cb, elementDsl, builder, configuration));
            ((SourceModel)model).getErrorCallback().ifPresent(cb -> this.populateParameterizedElements((ParameterizedModel)cb, elementDsl, builder, configuration));
        }
    }

    private void populateParameterizedElements(ParameterizedModel model, DslElementSyntax elementDsl, DslElementModel.Builder builder, ComponentConfiguration configuration) {
        Multimap<ComponentIdentifier, ComponentConfiguration> innerComponents = this.getNestedComponents(configuration);
        Map parameters = configuration.getParameters();
        List inlineGroupedParameters = model.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).peek(group -> this.addInlineGroup(elementDsl, innerComponents, parameters, builder, (ParameterGroupModel)group)).flatMap(g -> g.getParameterModels().stream()).collect(Collectors.toList());
        model.getAllParameterModels().stream().filter(p -> !inlineGroupedParameters.contains(p)).forEach(p -> this.addElementParameter(innerComponents, parameters, elementDsl, (DslElementModel.Builder<ParameterGroupModel>)builder, (ParameterModel)p));
    }

    private void populateComposableElements(ComposableModel model, DslElementSyntax elementDsl, DslElementModel.Builder builder, ComponentConfiguration configuration) {
        configuration.getNestedComponents().forEach(nestedComponentConfig -> {
            DslElementModel nestedElement = this.createIdentifiedElement((ComponentConfiguration)nestedComponentConfig);
            if (nestedElement != null) {
                builder.containing(nestedElement);
            } else {
                model.getNestedComponents().stream().filter(nestedModel -> nestedModel instanceof NestedRouteModel).filter(nestedModel -> elementDsl.getContainedElement(nestedModel.getName()).map(nestedDsl -> this.getIdentifier((DslElementSyntax)nestedDsl).map(id -> nestedComponentConfig.getIdentifier().equals(id)).orElse(false)).orElse(false)).findFirst().ifPresent(nestedModel -> {
                    DslElementSyntax routeDsl = (DslElementSyntax)elementDsl.getContainedElement(nestedModel.getName()).get();
                    DslElementModel.Builder routeBuilder = DslElementModel.builder().withModel(nestedModel).withDsl(routeDsl).withConfig(nestedComponentConfig).isExplicitInDsl(true);
                    this.populateParameterizedElements((ParameterizedModel)nestedModel, routeDsl, routeBuilder, (ComponentConfiguration)nestedComponentConfig);
                    nestedComponentConfig.getNestedComponents().forEach(routeElement -> {
                        DslElementModel nestableElementModel = this.createIdentifiedElement((ComponentConfiguration)routeElement);
                        if (nestableElementModel != null) {
                            routeBuilder.containing(nestableElementModel);
                        }
                    });
                    builder.containing(routeBuilder.build());
                });
            }
        });
    }

    private void addInlineGroup(DslElementSyntax elementDsl, Multimap<ComponentIdentifier, ComponentConfiguration> innerComponents, Map<String, String> parameters, DslElementModel.Builder parent, ParameterGroupModel group) {
        elementDsl.getChild(group.getName()).ifPresent(groupDsl -> {
            Optional<ComponentIdentifier> identifier = this.getIdentifier((DslElementSyntax)groupDsl);
            if (!identifier.isPresent()) {
                return;
            }
            ComponentConfiguration groupComponent = this.getSingleComponentConfiguration(innerComponents, identifier);
            if (groupComponent != null) {
                DslElementModel.Builder groupElementBuilder = DslElementModel.builder().withModel((Object)group).withDsl(groupDsl).withConfig(groupComponent);
                Multimap<ComponentIdentifier, ComponentConfiguration> groupInnerComponents = this.getNestedComponents(groupComponent);
                group.getParameterModels().forEach(p -> this.addElementParameter(groupInnerComponents, parameters, (DslElementSyntax)groupDsl, (DslElementModel.Builder<ParameterGroupModel>)groupElementBuilder, (ParameterModel)p));
                parent.containing(groupElementBuilder.build());
            } else if (this.shoulBuildDefaultGroup(group)) {
                this.builDefaultInlineGroupElement(parent, group, (DslElementSyntax)groupDsl, identifier.get());
            }
        });
    }

    private ComponentConfiguration getSingleComponentConfiguration(Multimap<ComponentIdentifier, ComponentConfiguration> innerComponents, Optional<ComponentIdentifier> identifier) {
        return identifier.filter(arg_0 -> innerComponents.containsKey(arg_0)).map(arg_0 -> innerComponents.get(arg_0)).map(collection -> (ComponentConfiguration)collection.iterator().next()).orElse(null);
    }

    private void builDefaultInlineGroupElement(DslElementModel.Builder parent, ParameterGroupModel group, DslElementSyntax groupDsl, ComponentIdentifier identifier) {
        ComponentConfiguration.Builder groupConfigBuilder = ComponentConfiguration.builder().withIdentifier(identifier);
        DslElementModel.Builder groupElementBuilder = DslElementModel.builder().withModel((Object)group).isExplicitInDsl(false).withDsl(groupDsl);
        group.getParameterModels().forEach(paramModel -> groupDsl.getContainedElement(paramModel.getName()).ifPresent(paramDsl -> ExtensionModelUtils.getDefaultValue((ParameterModel)paramModel).ifPresent(defaultValue -> {
            DslElementModel.Builder paramElementBuilder = DslElementModel.builder().withModel(paramModel).withDsl(paramDsl).isExplicitInDsl(false).withValue(defaultValue);
            if (ExtensionModelUtils.isContent((ParameterModel)paramModel) || ExtensionModelUtils.isText((ParameterModel)paramModel)) {
                this.getIdentifier((DslElementSyntax)paramDsl).ifPresent(tagId -> groupConfigBuilder.withNestedComponent(ComponentConfiguration.builder().withIdentifier(tagId).withValue(defaultValue).build()));
            } else {
                groupConfigBuilder.withParameter(paramDsl.getAttributeName(), defaultValue);
            }
            groupElementBuilder.containing(paramElementBuilder.build());
        })));
        groupElementBuilder.withConfig(groupConfigBuilder.build());
        parent.containing(groupElementBuilder.build());
    }

    private boolean shoulBuildDefaultGroup(ParameterGroupModel group) {
        return !ExtensionModelUtils.isRequired((ParameterGroupModel)group) && group.getParameterModels().stream().anyMatch(p -> ExtensionModelUtils.getDefaultValue((ParameterModel)p).isPresent());
    }

    private void addElementParameter(Multimap<ComponentIdentifier, ComponentConfiguration> innerComponents, Map<String, String> parameters, DslElementSyntax groupDsl, DslElementModel.Builder<ParameterGroupModel> groupElementBuilder, ParameterModel paramModel) {
        groupDsl.getContainedElement(paramModel.getName()).ifPresent(paramDsl -> {
            if (ExtensionModelUtils.isInfrastructure((ParameterModel)paramModel)) {
                this.handleInfrastructure(paramModel, (DslElementSyntax)paramDsl, innerComponents, parameters, groupElementBuilder);
                return;
            }
            ComponentConfiguration paramComponent = this.getSingleComponentConfiguration(innerComponents, this.getIdentifier((DslElementSyntax)paramDsl));
            if (paramDsl.isWrapped()) {
                this.resolveWrappedElement(groupElementBuilder, paramModel, (DslElementSyntax)paramDsl, paramComponent);
                return;
            }
            String value = paramDsl.supportsAttributeDeclaration() ? (String)parameters.get(paramDsl.getAttributeName()) : null;
            Optional defaultValue = ExtensionModelUtils.getDefaultValue((ParameterModel)paramModel);
            if (paramComponent != null || !StringUtils.isBlank((CharSequence)value) || defaultValue.isPresent()) {
                DslElementModel.Builder paramElementBuilder = DslElementModel.builder().withModel((Object)paramModel).withDsl(paramDsl);
                if (paramComponent != null && !ExtensionModelUtils.isContent((ParameterModel)paramModel)) {
                    paramElementBuilder.withConfig(paramComponent);
                    paramModel.getType().accept(new MetadataTypeVisitor((DslElementSyntax)paramDsl, paramComponent, paramElementBuilder, defaultValue){
                        final /* synthetic */ DslElementSyntax val$paramDsl;
                        final /* synthetic */ ComponentConfiguration val$paramComponent;
                        final /* synthetic */ DslElementModel.Builder val$paramElementBuilder;
                        final /* synthetic */ Optional val$defaultValue;
                        {
                            this.val$paramDsl = dslElementSyntax;
                            this.val$paramComponent = componentConfiguration;
                            this.val$paramElementBuilder = builder;
                            this.val$defaultValue = optional;
                        }

                        public void visitArrayType(ArrayType arrayType) {
                            MetadataType itemType = arrayType.getType();
                            this.val$paramDsl.getGeneric(itemType).ifPresent(itemdsl -> {
                                ComponentIdentifier itemIdentifier = ConfigurationBasedElementModelFactory.this.getIdentifier((DslElementSyntax)itemdsl).get();
                                this.val$paramComponent.getNestedComponents().forEach(c -> {
                                    if (c.getIdentifier().equals(itemIdentifier)) {
                                        itemType.accept(ConfigurationBasedElementModelFactory.this.getComponentChildVisitor(this.val$paramElementBuilder, (ComponentConfiguration)c, itemType, "value", (DslElementSyntax)itemdsl, this.val$defaultValue, (Deque<String>)new ArrayDeque<String>()));
                                    }
                                });
                            });
                        }

                        public void visitObject(ObjectType objectType) {
                            if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                                ConfigurationBasedElementModelFactory.this.populateMapEntries(objectType, this.val$paramDsl, this.val$paramElementBuilder, this.val$paramComponent);
                                return;
                            }
                            ConfigurationBasedElementModelFactory.this.populateObjectFields(objectType, this.val$paramComponent, this.val$paramDsl, this.val$paramElementBuilder, new ArrayDeque<String>());
                        }
                    });
                } else {
                    if (StringUtils.isBlank((CharSequence)value)) {
                        if (paramComponent != null && paramComponent.getValue().isPresent() && !StringUtils.isBlank((CharSequence)((CharSequence)paramComponent.getValue().get()))) {
                            value = ((String)paramComponent.getValue().get()).trim();
                        } else if (defaultValue.isPresent()) {
                            value = (String)defaultValue.get();
                            paramElementBuilder.isExplicitInDsl(false);
                        }
                    }
                    paramElementBuilder.withValue(value);
                }
                groupElementBuilder.containing(paramElementBuilder.build());
            }
        });
    }

    private void resolveWrappedElement(DslElementModel.Builder<ParameterGroupModel> groupElementBuilder, ParameterModel p, DslElementSyntax pDsl, ComponentConfiguration paramComponent) {
        if (paramComponent != null) {
            DslElementModel.Builder paramElement = DslElementModel.builder().withModel((Object)p).withDsl(pDsl).withConfig(paramComponent);
            if (paramComponent.getNestedComponents().size() > 0) {
                ExtensionModel wrapperExtension = this.currentExtension;
                DslSyntaxResolver wrapperDsl = this.dsl;
                ComponentConfiguration wrappedComponent = (ComponentConfiguration)paramComponent.getNestedComponents().get(0);
                this.create(wrappedComponent).ifPresent(arg_0 -> ((DslElementModel.Builder)paramElement).containing(arg_0));
                this.currentExtension = wrapperExtension;
                this.dsl = wrapperDsl;
            }
            groupElementBuilder.containing(paramElement.build());
        }
    }

    private Optional<ComponentIdentifier> getIdentifier(DslElementSyntax dsl) {
        if (StringUtils.isNotBlank((CharSequence)dsl.getElementName()) && StringUtils.isNotBlank((CharSequence)dsl.getPrefix())) {
            return Optional.of(ComponentIdentifier.builder().name(dsl.getElementName()).namespace(dsl.getPrefix()).build());
        }
        return Optional.empty();
    }

    private void handleInfrastructure(ParameterModel paramModel, DslElementSyntax paramDsl, Multimap<ComponentIdentifier, ComponentConfiguration> nested, Map<String, String> parameters, DslElementModel.Builder<ParameterGroupModel> groupElementBuilder) {
        switch (paramModel.getName()) {
            case "reconnection": {
                ComponentConfiguration reconnection = this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.RECONNECTION_CONFIG_PARAMETER_IDENTIFIER));
                if (reconnection != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, reconnection));
                }
                return;
            }
            case "reconnectionStrategy": {
                ComponentConfiguration config;
                ComponentConfiguration componentConfiguration = config = nested.containsKey((Object)ApplicationModel.RECONNECT_IDENTIFIER) ? this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.RECONNECT_IDENTIFIER)) : this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.RECONNECT_FOREVER_IDENTIFIER));
                if (config != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, config));
                }
                return;
            }
            case "redeliveryPolicy": {
                ComponentConfiguration redelivery = this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.REDELIVERY_POLICY_IDENTIFIER));
                if (redelivery != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, redelivery));
                }
                return;
            }
            case "expirationPolicy": {
                ComponentConfiguration expiration = this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.EXPIRATION_POLICY_IDENTIFIER));
                if (expiration != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, expiration));
                }
                return;
            }
            case "poolingProfile": {
                ComponentConfiguration pooling = this.getSingleComponentConfiguration(nested, this.getIdentifier(paramDsl));
                if (pooling != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, pooling));
                }
                return;
            }
            case "streamingStrategy": {
                HashSet streaming = Sets.newHashSet((Object[])new ComponentIdentifier[]{ApplicationModel.NON_REPEATABLE_STREAM_IDENTIFIER, ApplicationModel.REPEATABLE_IN_MEMORY_STREAM_IDENTIFIER, ApplicationModel.REPEATABLE_FILE_STORE_STREAM_IDENTIFIER, ApplicationModel.REPEATABLE_IN_MEMORY_ITERABLE_IDENTIFIER, ApplicationModel.REPEATABLE_FILE_STORE_ITERABLE_IDENTIFIER, ApplicationModel.NON_REPEATABLE_ITERABLE_IDENTIFIER});
                streaming.stream().filter(arg_0 -> nested.containsKey(arg_0)).findFirst().ifPresent(s -> groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, this.getSingleComponentConfiguration(nested, Optional.of(s)))));
                return;
            }
            case "tlsContext": {
                ComponentConfiguration tls = this.getSingleComponentConfiguration(nested, this.getIdentifier(paramDsl));
                if (tls != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, tls));
                } else if (!StringUtils.isBlank((CharSequence)parameters.get("tlsContext"))) {
                    groupElementBuilder.containing(DslElementModel.builder().withModel((Object)paramModel).withDsl(paramDsl).withValue(parameters.get("tlsContext")).build());
                }
                return;
            }
            case "schedulingStrategy": {
                ComponentConfiguration schedulingStrategyWrapper = this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.SCHEDULING_STRATEGY_IDENTIFIER));
                if (schedulingStrategyWrapper != null) {
                    DslElementModel.Builder wrapper = DslElementModel.builder().withModel((Object)paramModel).withDsl(paramDsl).withConfig(schedulingStrategyWrapper);
                    Iterator nestedIt = schedulingStrategyWrapper.getNestedComponents().iterator();
                    if (nestedIt.hasNext()) {
                        ComponentConfiguration strategy = (ComponentConfiguration)nestedIt.next();
                        MetadataType type = ApplicationModel.CRON_STRATEGY_IDENTIFIER.equals(strategy.getIdentifier()) ? this.typeLoader.load(CronScheduler.class) : this.typeLoader.load(FixedFrequencyScheduler.class);
                        this.dsl.resolve(type).ifPresent(typeDsl -> wrapper.containing(DslElementModel.builder().withModel((Object)type).withDsl(typeDsl).withConfig(strategy).build()));
                    }
                    groupElementBuilder.containing(wrapper.build());
                }
                return;
            }
        }
    }

    private DslElementModel newElementModel(ParameterModel paramModel, DslElementSyntax paramDsl, ComponentConfiguration configuration) {
        return DslElementModel.builder().withModel((Object)paramModel).withDsl(paramDsl).withConfig(configuration).build();
    }

    private static /* synthetic */ void lambda$getNestedComponents$8(Multimap result, ComponentConfiguration componentConfiguration) {
        result.put((Object)componentConfiguration.getIdentifier(), (Object)componentConfiguration);
    }
}

