/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateComponentBeanDefinitionRequest;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.MapEntry;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;

class MapEntryBeanDefinitionCreator
extends BeanDefinitionCreator<CreateComponentBeanDefinitionRequest> {
    private static final String ENTRY_TYPE_KEY_PARAMETER_NAME = "key";
    private static final String ENTRY_TYPE_VALUE_REF_PARAMETER_NAME = "value-ref";

    MapEntryBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(Map<ComponentAst, SpringComponentModel> springComponentModels, CreateComponentBeanDefinitionRequest request) {
        ComponentAst component = request.getComponent();
        Class type = request.getSpringComponentModel().getType();
        if (!TypeDefinition.MapEntryType.class.isAssignableFrom(type)) {
            return false;
        }
        ComponentBuildingDefinition componentBuildingDefinition = request.getComponentBuildingDefinition();
        request.getSpringComponentModel().setType(type);
        String key = component.getParameter("General", ENTRY_TYPE_KEY_PARAMETER_NAME).getResolvedRawValue();
        TypeDefinition.MapEntryType mapEntryType = request.getSpringComponentModel().getMapEntryType();
        BeanDefinition keyBeanDefinition = this.getConvertibleBeanDefinition(mapEntryType.getKeyType(), key, componentBuildingDefinition.getKeyTypeConverter());
        ComponentParameterAst valueRefParam = component.getParameter("General", ENTRY_TYPE_VALUE_REF_PARAMETER_NAME);
        Object value = valueRefParam != null ? new RuntimeBeanReference(valueRefParam.getResolvedRawValue()) : this.getValue(springComponentModels, mapEntryType, component, componentBuildingDefinition, request.getNestedComponentParamProcessor());
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(MapEntry.class).addConstructorArgValue((Object)keyBeanDefinition).addConstructorArgValue(value).getBeanDefinition();
        request.getSpringComponentModel().setBeanDefinition((BeanDefinition)beanDefinition);
        return true;
    }

    private Object getValue(Map<ComponentAst, SpringComponentModel> springComponentModels, TypeDefinition.MapEntryType mapEntryType, ComponentAst component, ComponentBuildingDefinition componentBuildingDefinition, Consumer<ComponentAst> nestedComponentParamProcessor) {
        Class valueType = mapEntryType.getValueType();
        return component.getParameter("General", "value").getValue().mapLeft(v -> this.getConvertibleBeanDefinition(valueType, "#[" + v + "]", componentBuildingDefinition.getTypeConverter())).mapRight(v -> {
            if (List.class.isAssignableFrom(valueType)) {
                Collection values = (Collection)v;
                values.forEach(nestedComponentParamProcessor);
                ManagedList managedList = values.stream().map(springComponentModels::get).map(childSpringComponent -> childSpringComponent.getBeanDefinition() != null ? childSpringComponent.getBeanDefinition() : childSpringComponent.getBeanReference()).collect(Collectors.toCollection(ManagedList::new));
                return BeanDefinitionBuilder.genericBeanDefinition(ObjectTypeVisitor.DEFAULT_COLLECTION_TYPE).addConstructorArgValue((Object)managedList).getBeanDefinition();
            }
            if (v instanceof ComponentAst) {
                nestedComponentParamProcessor.accept((ComponentAst)v);
                SpringComponentModel childSpringComponent2 = (SpringComponentModel)springComponentModels.get(v);
                BeanDefinition beanDefinition = childSpringComponent2.getBeanDefinition();
                return beanDefinition != null ? beanDefinition : childSpringComponent2.getBeanReference();
            }
            return this.getConvertibleBeanDefinition(valueType, v, componentBuildingDefinition.getTypeConverter());
        }).getValue().orElse(null);
    }
}

