/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.lang.reflect.Proxy;
import java.util.Objects;

public class BeanWrapper {
    private final Object wrappedObject;
    private final String name;
    private final int cachedHashCode;

    public BeanWrapper(String name, Object o) {
        Objects.requireNonNull(o, "bean must not be null");
        this.name = name;
        this.wrappedObject = o;
        this.cachedHashCode = this.calculateHashCode();
    }

    public Object getWrappedObject() {
        return this.wrappedObject;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj || this.wrappedObject.equals(obj)) {
            return true;
        }
        if (!(obj instanceof BeanWrapper)) {
            return false;
        }
        if (Proxy.isProxyClass(this.wrappedObject.getClass()) && Proxy.isProxyClass(((BeanWrapper)obj).wrappedObject.getClass())) {
            return this.wrappedObject == ((BeanWrapper)obj).wrappedObject || this.wrappedObject.hashCode() == ((BeanWrapper)obj).wrappedObject.hashCode();
        }
        if (Proxy.isProxyClass(((BeanWrapper)obj).wrappedObject.getClass())) {
            return ((BeanWrapper)obj).wrappedObject.equals(this.wrappedObject);
        }
        return this.wrappedObject.equals(((BeanWrapper)obj).wrappedObject);
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    private int calculateHashCode() {
        return this.wrappedObject.hashCode();
    }
}

