/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Strings;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionsDataExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionsDataExtractor.class);
    private final String artifactName;
    private final List<ConnectionData> connections;

    public ConnectionsDataExtractor(ArtifactAst artifactAst) {
        this.artifactName = artifactAst.getArtifactName();
        if (!Boolean.getBoolean("mule.extractConnectionData.enable")) {
            this.connections = new ArrayList<ConnectionData>();
            return;
        }
        HashSet seenConnectionLocations = new HashSet();
        this.connections = artifactAst.recursiveStream().peek(comp -> {
            if (TypedComponentIdentifier.ComponentType.CONNECTION.equals((Object)comp.getComponentType())) {
                seenConnectionLocations.add(comp);
            }
        }).filter(comp -> comp.getModel(ParameterizedModel.class).isPresent()).map(comp -> {
            String host = null;
            Object port = "-1";
            for (ComponentParameterAst param : comp.getParameters()) {
                if (param.getValue() == null || param.getValue().getRight() == null) continue;
                try {
                    String paramName = param.getModel().getName();
                    Object paramValue = param.getValue().getRight();
                    if (Strings.CI.contains((CharSequence)paramName, (CharSequence)"url") || Strings.CI.contains((CharSequence)paramName, (CharSequence)"uri")) {
                        try {
                            URI uriParam = URI.create(paramValue.toString());
                            host = uriParam.getHost();
                            int portFromUri = uriParam.getPort();
                            if (portFromUri == -1) {
                                String scheme = uriParam.getScheme();
                                if ("http".equals(scheme)) {
                                    port = "80";
                                } else if ("https".equals(scheme)) {
                                    port = "443";
                                }
                            } else {
                                port = "" + portFromUri;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            LOGGER.warn("Exception {} parsing url {}", (Object)e, paramValue);
                        }
                    }
                    if (Strings.CI.contains((CharSequence)paramName, (CharSequence)"host")) {
                        host = paramValue.toString();
                    }
                    if (Strings.CI.contains((CharSequence)paramName, (CharSequence)"port")) {
                        port = paramValue.toString();
                    }
                    if (!"0.0.0.0".equals(host)) continue;
                    host = "localhost";
                }
                catch (Exception e) {
                    LOGGER.error("Exception thrown for param " + param.getModel().getName() + " @ " + comp.getLocation().getLocation(), (Throwable)e);
                    if (Boolean.getBoolean("mule.extractConnectionData.silentErrors")) {
                        return Optional.empty();
                    }
                    throw e;
                }
            }
            if (host != null) {
                return Optional.of(new ConnectionData(comp.getLocation().getLocation(), comp.getIdentifier().toString(), host, (String)port));
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        seenConnectionLocations.stream().filter(seenConn -> this.connections.stream().noneMatch(conn -> conn.location.startsWith(seenConn.getLocation().getLocation()))).map(seenConn -> new ConnectionData(seenConn.getLocation().getLocation(), seenConn.getIdentifier().toString(), "", "-1")).forEach(this.connections::add);
    }

    public void persist() {
        block9: {
            if (!Boolean.getBoolean("mule.extractConnectionData.enable")) {
                return;
            }
            File muleBaseFolder = MuleFoldersUtil.getMuleBaseFolder();
            File tlsDir = new File(muleBaseFolder, ".mule/.introspection");
            tlsDir.mkdirs();
            String fileName = "connections_data_%s.csv".formatted(this.artifactName);
            File targetFile = new File(tlsDir, fileName);
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(targetFile)));){
                bufferedWriter.write("Component,Host,Port" + System.lineSeparator());
                LOGGER.debug("Component,Host,Port");
                for (ConnectionData connectionData : this.connections) {
                    bufferedWriter.write(String.valueOf(connectionData) + System.lineSeparator());
                    LOGGER.debug("{}", (Object)connectionData);
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception thrown when writing '" + fileName + "'", (Throwable)e);
                if (!Boolean.getBoolean("mule.extractConnectionData.silentErrors")) break block9;
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private record ConnectionData(String location, String identifier, String host, String port) {
        @Override
        public final String toString() {
            return "\"%s(%s)\",\"%s\",\"%s\"".formatted(this.location, this.identifier, this.host, this.port);
        }
    }
}

