/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.MetadataTypeAdapter;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.properties.PropertiesResolverUtils;
import org.mule.runtime.config.internal.context.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.dsl.XmlConstants;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CollectionBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CommonComponentBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CommonDslParamGroupBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CommonParamBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ComponentModelHelper;
import org.mule.runtime.config.internal.dsl.spring.CreateComponentBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.CreateDslParamGroupBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.CreateParamBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.EagerObjectCreator;
import org.mule.runtime.config.internal.dsl.spring.MapBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.MapEntryBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ObjectBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.config.internal.dsl.spring.SimpleTypeBeanComponentDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.SimpleTypeBeanParamDefinitionCreator;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class BeanDefinitionFactory {
    public static final String SPRING_PROTOTYPE_OBJECT = "prototype";
    public static final String SPRING_SINGLETON_OBJECT = "singleton";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String TARGET_TYPE = "targetType";
    public static final String OBJECT_SERIALIZER_REF = "defaultObjectSerializer-ref";
    public static final String CORE_ERROR_NS = "mule".toUpperCase();
    private final ImmutableSet<ComponentIdentifier> ignoredMuleCoreComponentIdentifiers = ImmutableSet.builder().add((Object)ApplicationModel.DESCRIPTION_IDENTIFIER).add((Object)ApplicationModel.ANNOTATIONS_ELEMENT_IDENTIFIER).add((Object)ApplicationModel.DOC_DESCRIPTION_IDENTIFIER).add((Object)ApplicationModel.GLOBAL_PROPERTY_IDENTIFIER).build();
    private final Set<ComponentIdentifier> ignoredMuleExtensionComponentIdentifiers;
    private final ImmutableSet<ComponentIdentifier> customBuildersComponentIdentifiers = ImmutableSet.builder().add((Object)ApplicationModel.MULE_PROPERTIES_IDENTIFIER).add((Object)ApplicationModel.MULE_PROPERTY_IDENTIFIER).add((Object)ApplicationModel.OBJECT_IDENTIFIER).build();
    private final String artifactId;
    private final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry;
    private final BeanDefinitionCreator<CreateComponentBeanDefinitionRequest> componentProcessor;
    private final BeanDefinitionCreator<CreateDslParamGroupBeanDefinitionRequest> dslParamGroupProcessor;
    private final BeanDefinitionCreator<CreateParamBeanDefinitionRequest> paramProcessor;
    private final ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();

    public BeanDefinitionFactory(String artifactId, ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry, boolean disableTrimWhitespaces, boolean disablePojoCdataTrimWhitespaces) {
        this.artifactId = artifactId;
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
        this.componentProcessor = this.buildComponentProcessorChainOfResponsability(disableTrimWhitespaces);
        this.dslParamGroupProcessor = this.buildDslParamGroupChainOfResponsability(disableTrimWhitespaces);
        this.paramProcessor = this.buildParamChainOfResponsability(disableTrimWhitespaces, disablePojoCdataTrimWhitespaces);
        this.ignoredMuleExtensionComponentIdentifiers = new HashSet<ComponentIdentifier>();
        this.registerConfigurationPropertyProviders();
    }

    private void registerConfigurationPropertyProviders() {
        this.ignoredMuleExtensionComponentIdentifiers.addAll(PropertiesResolverUtils.loadProviderFactories().keySet());
    }

    public boolean isComponentIgnored(ComponentIdentifier identifier) {
        return this.ignoredMuleCoreComponentIdentifiers.contains((Object)identifier) || this.ignoredMuleExtensionComponentIdentifiers.contains(identifier);
    }

    public void resolveComponent(Map<ComponentAst, SpringComponentModel> springComponentModels, List<ComponentAst> componentHierarchy, ComponentAst component, BeanDefinitionRegistry registry, SpringConfigurationComponentLocator componentLocator) {
        if (this.isComponentIgnored(component.getIdentifier())) {
            return;
        }
        ArrayList<SpringComponentModel> paramsModels = new ArrayList<SpringComponentModel>();
        component.getModel(ParameterizedModel.class).ifPresent(pmzd -> {
            if (pmzd instanceof SourceModel) {
                ((SourceModel)pmzd).getSuccessCallback().ifPresent(cbk -> cbk.getParameterGroupModels().stream().map(pmg -> this.resolveParameterGroup(springComponentModels, componentHierarchy, component, (ParameterGroupModel)pmg, registry, componentLocator)).forEach(paramsModels::addAll));
                ((SourceModel)pmzd).getErrorCallback().ifPresent(cbk -> cbk.getParameterGroupModels().stream().map(pmg -> this.resolveParameterGroup(springComponentModels, componentHierarchy, component, (ParameterGroupModel)pmg, registry, componentLocator)).forEach(paramsModels::addAll));
            }
            pmzd.getParameterGroupModels().stream().map(pmg -> this.resolveParameterGroup(springComponentModels, componentHierarchy, component, (ParameterGroupModel)pmg, registry, componentLocator)).forEach(paramsModels::addAll);
        });
        ArrayList<ComponentAst> nestedHierarchy = new ArrayList<ComponentAst>(componentHierarchy);
        nestedHierarchy.add(component);
        this.resolveComponentBeanDefinition(springComponentModels, componentHierarchy, component, paramsModels, registry, componentLocator, nestedComp -> this.resolveComponent(springComponentModels, (List<ComponentAst>)nestedHierarchy, (ComponentAst)nestedComp, registry, componentLocator));
    }

    private List<SpringComponentModel> resolveParameterGroup(Map<ComponentAst, SpringComponentModel> springComponentModels, List<ComponentAst> componentHierarchy, ComponentAst component, ParameterGroupModel groupModel, BeanDefinitionRegistry registry, SpringConfigurationComponentLocator componentLocator) {
        ArrayList<SpringComponentModel> paramsModels = new ArrayList<SpringComponentModel>();
        ArrayList<SpringComponentModel> groupParamsModels = new ArrayList<SpringComponentModel>();
        AtomicBoolean anyParamPresent = new AtomicBoolean();
        groupModel.getParameterModels().forEach(pm -> {
            ComponentParameterAst param = component.getParameter(groupModel.getName(), pm.getName());
            if (param != null && param.getValue() != null && param.getValue().getValue().isPresent()) {
                groupParamsModels.addAll(this.resolveParamBeanDefinition(springComponentModels, componentHierarchy, component, param, registry, componentLocator));
                anyParamPresent.set(true);
            }
        });
        if (anyParamPresent.get()) {
            if (groupModel.isShowInDsl()) {
                ArrayList<ComponentAst> nestedHierarchy = new ArrayList<ComponentAst>(componentHierarchy);
                nestedHierarchy.add(component);
                this.resolveComponentBeanDefinitionDslParamGroup(springComponentModels, nestedHierarchy, groupModel, groupParamsModels).ifPresent(springComponentModel -> {
                    paramsModels.add((SpringComponentModel)springComponentModel);
                    this.handleSpringComponentModel((SpringComponentModel)springComponentModel, springComponentModels, registry, componentLocator);
                });
            } else {
                paramsModels.addAll(groupParamsModels);
            }
        }
        return paramsModels;
    }

    private List<SpringComponentModel> resolveParamBeanDefinition(Map<ComponentAst, SpringComponentModel> springComponentModels, List<ComponentAst> componentHierarchy, ComponentAst paramOwnerComponent, ComponentParameterAst param, BeanDefinitionRegistry registry, SpringConfigurationComponentLocator componentLocator) {
        return (List)param.getValue().reduce(expr -> this.resolveParamBeanDefinitionSimpleType(springComponentModels, componentHierarchy, paramOwnerComponent, param, registry, componentLocator).map(Collections::singletonList).orElse(Collections.emptyList()), v -> this.resolveParamBeanDefinitionFixedValue(springComponentModels, componentHierarchy, paramOwnerComponent, param, registry, componentLocator));
    }

    private List<SpringComponentModel> resolveParamBeanDefinitionFixedValue(final Map<ComponentAst, SpringComponentModel> springComponentModels, final List<ComponentAst> componentHierarchy, final ComponentAst paramOwnerComponent, final ComponentParameterAst param, final BeanDefinitionRegistry registry, final SpringConfigurationComponentLocator componentLocator) {
        final AtomicReference model = new AtomicReference();
        param.getModel().getType().accept(new MetadataTypeVisitor(){

            protected void visitMultipleChildren(List<Object> values) {
                ArrayList<ComponentAst> updatedHierarchy = new ArrayList<ComponentAst>(componentHierarchy);
                updatedHierarchy.add(paramOwnerComponent);
                if (values != null) {
                    values.stream().filter(child -> child instanceof ComponentAst).forEach(child -> BeanDefinitionFactory.this.resolveComponentBeanDefinition(springComponentModels, updatedHierarchy, (ComponentAst)child, Collections.emptyList(), registry, componentLocator, nestedComp -> BeanDefinitionFactory.this.resolveComponent(springComponentModels, updatedHierarchy, (ComponentAst)nestedComp, registry, componentLocator)));
                }
                BeanDefinitionFactory.this.resolveComponentBeanDefinitionComplexParam(springComponentModels, updatedHierarchy, paramOwnerComponent, param, Collections.emptySet(), registry, componentLocator, nestedComp -> BeanDefinitionFactory.this.resolveComponent(springComponentModels, componentHierarchy, (ComponentAst)nestedComp, registry, componentLocator)).ifPresent(model::set);
            }

            public void visitArrayType(ArrayType arrayType) {
                Object complexValue = param.getValue().getRight();
                if (complexValue instanceof List) {
                    this.visitMultipleChildren((List)complexValue);
                } else {
                    BeanDefinitionFactory.this.resolveParamBeanDefinitionSimpleType(springComponentModels, componentHierarchy, paramOwnerComponent, param, registry, componentLocator).ifPresent(model::set);
                }
            }

            public void visitObject(ObjectType objectType) {
                Object complexValue = param.getValue().getRight();
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    if (complexValue instanceof List) {
                        this.visitMultipleChildren((List)complexValue);
                    } else {
                        BeanDefinitionFactory.this.resolveParamBeanDefinitionSimpleType(springComponentModels, componentHierarchy, paramOwnerComponent, param, registry, componentLocator).ifPresent(model::set);
                    }
                    return;
                }
                ArrayList<ComponentAst> updatedHierarchy = new ArrayList<ComponentAst>(componentHierarchy);
                updatedHierarchy.add(paramOwnerComponent);
                if (complexValue instanceof ComponentAst) {
                    ComponentAst child = (ComponentAst)complexValue;
                    ArrayList<SpringComponentModel> childParamsModels = new ArrayList<SpringComponentModel>();
                    child.getModel(ParameterizedModel.class).ifPresent(pmzd -> pmzd.getParameterGroupModels().stream().map(pmg -> BeanDefinitionFactory.this.resolveParameterGroup(springComponentModels, componentHierarchy, child, (ParameterGroupModel)pmg, registry, componentLocator)).forEach(childParamsModels::addAll));
                    updatedHierarchy.add(child);
                    BeanDefinitionFactory.this.resolveComponentBeanDefinitionComplexParam(springComponentModels, updatedHierarchy, paramOwnerComponent, param, childParamsModels, registry, componentLocator, nestedComp -> BeanDefinitionFactory.this.resolveComponent(springComponentModels, componentHierarchy, (ComponentAst)nestedComp, registry, componentLocator)).ifPresent(model::set);
                }
            }

            public void visitUnion(UnionType unionType) {
                Object complexValue = param.getValue().getRight();
                if (complexValue instanceof ComponentAst) {
                    unionType.getTypes().stream().filter(t -> ((ComponentAst)complexValue).getModel(MetadataTypeAdapter.class).map(a -> a.getType().equals(t)).orElse(false)).forEach(t -> this.visitObject((ObjectType)t));
                }
            }

            public void visitSimpleType(SimpleType simpleType) {
                BeanDefinitionFactory.this.resolveParamBeanDefinitionSimpleType(springComponentModels, componentHierarchy, paramOwnerComponent, param, registry, componentLocator).ifPresent(model::set);
            }
        });
        if (model.get() != null) {
            return Collections.singletonList((SpringComponentModel)model.get());
        }
        return Collections.emptyList();
    }

    private Optional<SpringComponentModel> resolveParamBeanDefinitionSimpleType(Map<ComponentAst, SpringComponentModel> springComponentModels, List<ComponentAst> componentHierarchy, ComponentAst paramOwnerComponent, ComponentParameterAst param, BeanDefinitionRegistry registry, SpringConfigurationComponentLocator componentLocator) {
        if (ExtensionModelUtils.isContent((ParameterModel)param.getModel()) || ExtensionModelUtils.isText((ParameterModel)param.getModel())) {
            ArrayList<ComponentAst> updatedHierarchy = new ArrayList<ComponentAst>(componentHierarchy);
            updatedHierarchy.add(paramOwnerComponent);
            return this.resolveComponentBeanDefinitionComplexParam(springComponentModels, updatedHierarchy, paramOwnerComponent, param, Collections.emptySet(), registry, componentLocator, nestedComp -> this.resolveComponent(springComponentModels, componentHierarchy, (ComponentAst)nestedComp, registry, componentLocator));
        }
        return Optional.empty();
    }

    private Optional<SpringComponentModel> resolveComponentBeanDefinition(Map<ComponentAst, SpringComponentModel> springComponentModels, List<ComponentAst> componentHierarchy, ComponentAst component, List<SpringComponentModel> paramsModels, BeanDefinitionRegistry registry, SpringConfigurationComponentLocator componentLocator, Consumer<ComponentAst> nestedComponentParamProcessor) {
        Optional<ComponentBuildingDefinition<?>> buildingDefinitionOptional = this.componentBuildingDefinitionRegistry.getBuildingDefinition(component.getIdentifier());
        if (buildingDefinitionOptional.isPresent() || this.customBuildersComponentIdentifiers.contains((Object)component.getIdentifier())) {
            CreateComponentBeanDefinitionRequest request = new CreateComponentBeanDefinitionRequest(componentHierarchy, component, paramsModels, buildingDefinitionOptional.orElse(null), nestedComponentParamProcessor);
            this.componentProcessor.processRequest(springComponentModels, request);
            this.handleSpringComponentModel(request.getSpringComponentModel(), springComponentModels, registry, componentLocator);
            return Optional.of(request.getSpringComponentModel());
        }
        return Optional.empty();
    }

    private Optional<SpringComponentModel> resolveComponentBeanDefinitionComplexParam(Map<ComponentAst, SpringComponentModel> springComponentModels, List<ComponentAst> componentHierarchy, ComponentAst paramOwnerComponent, ComponentParameterAst param, Collection<SpringComponentModel> paramsModels, BeanDefinitionRegistry registry, SpringConfigurationComponentLocator componentLocator, Consumer<ComponentAst> nestedComponentParamProcessor) {
        return paramOwnerComponent.getGenerationInformation().getSyntax().flatMap(ownerSyntax -> {
            if (param.getGroupModel().isShowInDsl()) {
                return ownerSyntax.getChild(param.getGroupModel().getName()).flatMap(dslGroupSyntax -> dslGroupSyntax.getChild(param.getModel().getName()));
            }
            if (ownerSyntax.getContainedElement(param.getModel().getName()).isPresent() && ((DslElementSyntax)ownerSyntax.getContainedElement(param.getModel().getName()).get()).isWrapped()) {
                return ownerSyntax.getContainedElement(param.getModel().getName());
            }
            return param.getGenerationInformation().getSyntax();
        }).filter(paramSyntax -> !StringUtils.isEmpty((CharSequence)paramSyntax.getElementName())).flatMap(paramSyntax -> {
            ComponentIdentifier paramComponentIdentifier = ComponentIdentifier.builder().namespaceUri(paramSyntax.getNamespace()).namespace(paramSyntax.getPrefix()).name(paramSyntax.getElementName()).build();
            ComponentIdentifier paramValueComponentIdentifier = this.getParamValueComponentIdentifier(param, paramComponentIdentifier);
            return this.resolveComplexParamBuildingDefinition(param, paramValueComponentIdentifier).map(buildingDefinition -> {
                CreateParamBeanDefinitionRequest request = new CreateParamBeanDefinitionRequest(componentHierarchy, paramsModels, paramOwnerComponent, param, (ComponentBuildingDefinition<?>)buildingDefinition, paramComponentIdentifier, nestedComponentParamProcessor);
                this.paramProcessor.processRequest(springComponentModels, request);
                param.getValue().applyRight(v -> {
                    if (v instanceof ComponentAst) {
                        request.getSpringComponentModel().setComponent((ComponentAst)v);
                    }
                });
                this.handleSpringComponentModel(request.getSpringComponentModel(), springComponentModels, registry, componentLocator);
                return request.getSpringComponentModel();
            });
        });
    }

    private ComponentIdentifier getParamValueComponentIdentifier(ComponentParameterAst param, ComponentIdentifier paramComponentIdentifier) {
        Object valueObject;
        if (param.getValue().getValue().isPresent() && (valueObject = param.getValue().getValue().get()) instanceof ComponentAst) {
            ComponentAst valueAst = (ComponentAst)valueObject;
            return valueAst.getIdentifier();
        }
        return param.getGenerationInformation().getSyntax().filter(paramValueSyntax -> !StringUtils.isEmpty((CharSequence)paramValueSyntax.getElementName())).map(paramValueSyntax -> ComponentIdentifier.builder().namespaceUri(paramValueSyntax.getNamespace()).namespace(paramValueSyntax.getPrefix()).name(paramValueSyntax.getElementName()).build()).orElse(paramComponentIdentifier);
    }

    private Optional<ComponentBuildingDefinition<?>> resolveComplexParamBuildingDefinition(ComponentParameterAst param, ComponentIdentifier paramValueComponentIdentifier) {
        if (param.getModel().getModelProperty(NoWrapperModelProperty.class).isPresent()) {
            return param.getModel().getType().getAnnotation(ClassInformationAnnotation.class).map(cia -> {
                try {
                    return new ComponentBuildingDefinition.Builder().withNamespace(paramValueComponentIdentifier.getNamespace()).withIdentifier(paramValueComponentIdentifier.getName()).withTypeDefinition(TypeDefinition.fromType(Class.forName(cia.getClassname()))).build();
                }
                catch (ClassNotFoundException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
        }
        return this.componentBuildingDefinitionRegistry.getBuildingDefinition(paramValueComponentIdentifier);
    }

    private ComponentBuildingDefinition noWrapperBeanDefinition(ComponentParameterAst param, ComponentIdentifier paramValueComponentIdentifier) {
        return param.getModel().getType().getAnnotation(ClassInformationAnnotation.class).map(cia -> {
            try {
                return new ComponentBuildingDefinition.Builder().withNamespace(paramValueComponentIdentifier.getNamespace()).withIdentifier(paramValueComponentIdentifier.getName()).withTypeDefinition(TypeDefinition.fromType(Class.forName(cia.getClassname()))).build();
            }
            catch (ClassNotFoundException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }).orElse(null);
    }

    private Optional<SpringComponentModel> resolveComponentBeanDefinitionDslParamGroup(Map<ComponentAst, SpringComponentModel> springComponentModels, List<ComponentAst> componentHierarchy, ParameterGroupModel paramGroupModel, Collection<SpringComponentModel> paramsModels) {
        ComponentAst paramOwnerComponentModel = componentHierarchy.get(componentHierarchy.size() - 1);
        return paramOwnerComponentModel.getGenerationInformation().getSyntax().flatMap(ownerSyntax -> ownerSyntax.getChild(paramGroupModel.getName())).flatMap(groupSyntax -> {
            ComponentIdentifier paramGroupComponentIdentifier = ComponentIdentifier.builder().namespaceUri(groupSyntax.getNamespace()).namespace(groupSyntax.getPrefix()).name(groupSyntax.getElementName()).build();
            return this.componentBuildingDefinitionRegistry.getBuildingDefinition(paramGroupComponentIdentifier).map(buildingDefinition -> {
                CreateDslParamGroupBeanDefinitionRequest request = new CreateDslParamGroupBeanDefinitionRequest(paramGroupModel, componentHierarchy, paramsModels, paramOwnerComponentModel, (ComponentBuildingDefinition<?>)buildingDefinition, paramGroupComponentIdentifier);
                this.dslParamGroupProcessor.processRequest(springComponentModels, request);
                return request.getSpringComponentModel();
            });
        });
    }

    protected void handleSpringComponentModel(SpringComponentModel springComponentModel, Map<ComponentAst, SpringComponentModel> springComponentModels, BeanDefinitionRegistry registry, SpringConfigurationComponentLocator componentLocator) {
        ComponentAst component = springComponentModel.getComponent();
        springComponentModels.put(component, springComponentModel);
        if (component == null) {
            return;
        }
        this.processMuleConfiguration(springComponentModels, component, registry);
        this.processMuleSecurityManager(springComponentModels, component, registry);
        this.componentBuildingDefinitionRegistry.getBuildingDefinition(component.getIdentifier()).ifPresent(componentBuildingDefinition -> {
            if (springComponentModel.getType() != null && Component.class.isAssignableFrom(springComponentModel.getType())) {
                ComponentModelHelper.addAnnotation(ComponentAnnotations.ANNOTATION_NAME, component.getIdentifier(), springComponentModel);
                HashMap rawParams = new HashMap();
                component.getMetadata().getDocAttributes().entrySet().stream().forEach(docAttr -> XmlConstants.buildRawParamKeyForDocAttribute(docAttr).ifPresent(key -> rawParams.put(key, (String)docAttr.getValue())));
                ComponentModelHelper.addAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS, component.getModel(ParameterizedModel.class).map(pm -> {
                    component.getParameters().stream().filter(param -> param.getValue().getValue().isPresent()).forEach(param -> rawParams.put(param.getModel().getName(), param.getValue().mapLeft(expr -> "#[" + expr + "]").getValue().get().toString()));
                    return rawParams;
                }).orElse(rawParams), springComponentModel);
                componentLocator.addComponentLocation(component.getLocation());
                ComponentModelHelper.addAnnotation(ComponentAnnotations.ANNOTATION_COMPONENT_CONFIG, component, springComponentModel);
            }
        });
        ComponentModelHelper.addAnnotation(AbstractComponent.LOCATION_KEY, component.getLocation(), springComponentModel);
        ComponentModelHelper.addAnnotation(Component.Annotations.REPRESENTATION_ANNOTATION_KEY, BeanDefinitionFactory.resolveProcessorRepresentation(this.artifactId, component.getLocation(), component.getMetadata()), springComponentModel);
    }

    public static String resolveProcessorRepresentation(String appId, ComponentLocation processorPath, ComponentMetadataAst metadata) {
        Object docName;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(processorPath.getLocation()).append(" @ ").append(appId);
        String sourceFile = metadata.getFileName().orElse(null);
        if (sourceFile != null) {
            stringBuilder.append(":").append(sourceFile).append(":").append(metadata.getStartLine().orElse(-1));
        }
        if ((docName = metadata.getDocAttributes().get(Component.Annotations.NAME_ANNOTATION_KEY.getLocalPart())) != null) {
            stringBuilder.append(" (").append(docName).append(")");
        }
        return stringBuilder.toString();
    }

    private void processMuleConfiguration(Map<ComponentAst, SpringComponentModel> springComponentModels, ComponentAst component, BeanDefinitionRegistry registry) {
        String defaultObjectSerializer;
        ComponentParameterAst objectSerializerRefParam;
        if (component.getIdentifier().equals(CoreDslConstants.CONFIGURATION_IDENTIFIER) && (objectSerializerRefParam = component.getParameter("General", OBJECT_SERIALIZER_REF)) != null && (defaultObjectSerializer = objectSerializerRefParam.getResolvedRawValue()) != null && !defaultObjectSerializer.equals("_muleDefaultObjectSerializer") && !registry.isAlias("_muleDefaultObjectSerializer")) {
            registry.removeBeanDefinition("_muleDefaultObjectSerializer");
            registry.registerAlias(defaultObjectSerializer, "_muleDefaultObjectSerializer");
        }
    }

    private void processMuleSecurityManager(Map<ComponentAst, SpringComponentModel> springComponentModels, ComponentAst component, BeanDefinitionRegistry registry) {
        if (component.getIdentifier().equals(ApplicationModel.SECURITY_MANAGER_IDENTIFIER)) {
            component.directChildrenStream().forEach(childComponentModel -> {
                String identifier = childComponentModel.getIdentifier().getName();
                if (identifier.equals("password-encryption-strategy") || identifier.equals("secret-key-encryption-strategy")) {
                    registry.registerBeanDefinition(childComponentModel.getParameter("General", "name").getResolvedRawValue(), ((SpringComponentModel)springComponentModels.get(childComponentModel)).getBeanDefinition());
                }
            });
        }
    }

    private BeanDefinitionCreator<CreateComponentBeanDefinitionRequest> buildComponentProcessorChainOfResponsability(boolean disableTrimWhitespaces) {
        EagerObjectCreator eagerObjectCreator = new EagerObjectCreator();
        ObjectBeanDefinitionCreator objectBeanDefinitionCreator = new ObjectBeanDefinitionCreator();
        SimpleTypeBeanComponentDefinitionCreator simpleTypeBeanDefinitionCreator = new SimpleTypeBeanComponentDefinitionCreator();
        MapEntryBeanDefinitionCreator mapEntryBeanDefinitionCreator = new MapEntryBeanDefinitionCreator();
        CommonComponentBeanDefinitionCreator commonComponentModelProcessor = new CommonComponentBeanDefinitionCreator(this.objectFactoryClassRepository, disableTrimWhitespaces);
        eagerObjectCreator.setNext(objectBeanDefinitionCreator);
        objectBeanDefinitionCreator.setNext(simpleTypeBeanDefinitionCreator);
        simpleTypeBeanDefinitionCreator.setNext(mapEntryBeanDefinitionCreator);
        mapEntryBeanDefinitionCreator.setNext(commonComponentModelProcessor);
        return eagerObjectCreator;
    }

    private BeanDefinitionCreator<CreateDslParamGroupBeanDefinitionRequest> buildDslParamGroupChainOfResponsability(boolean disableTrimWhitespaces) {
        return new CommonDslParamGroupBeanDefinitionCreator(this.objectFactoryClassRepository, disableTrimWhitespaces);
    }

    private BeanDefinitionCreator<CreateParamBeanDefinitionRequest> buildParamChainOfResponsability(boolean disableTrimWhitespaces, boolean disablePojoCdataTrimWhitespaces) {
        SimpleTypeBeanParamDefinitionCreator simpleTypeBeanDefinitionCreator = new SimpleTypeBeanParamDefinitionCreator(disableTrimWhitespaces, disablePojoCdataTrimWhitespaces);
        CollectionBeanDefinitionCreator collectionBeanDefinitionCreator = new CollectionBeanDefinitionCreator();
        MapBeanDefinitionCreator mapBeanDefinitionCreator = new MapBeanDefinitionCreator();
        CommonParamBeanDefinitionCreator commonComponentModelProcessor = new CommonParamBeanDefinitionCreator(this.objectFactoryClassRepository, disableTrimWhitespaces);
        simpleTypeBeanDefinitionCreator.setNext(collectionBeanDefinitionCreator);
        collectionBeanDefinitionCreator.setNext(mapBeanDefinitionCreator);
        mapBeanDefinitionCreator.setNext(commonComponentModelProcessor);
        return simpleTypeBeanDefinitionCreator;
    }

    public boolean hasDefinition(ComponentIdentifier componentIdentifier) {
        return this.isComponentIgnored(componentIdentifier) || this.customBuildersComponentIdentifiers.contains((Object)componentIdentifier) || this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentIdentifier).isPresent() || this.componentBuildingDefinitionRegistry.getWrappedComponent(componentIdentifier).isPresent();
    }

    public boolean isLanguageConstructComponent(ComponentIdentifier componentIdentifier) {
        return this.customBuildersComponentIdentifiers.contains((Object)componentIdentifier);
    }
}

