/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.lazy;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.ast.internal.FilteredArtifactAst;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.internal.context.lazy.ComponentInitializationState;
import org.mule.runtime.core.api.config.ConfigurationException;

class ComponentInitializationRequest {
    private final ArtifactAstDependencyGraph graph;
    private final ComponentInitializationState componentInitializationState;
    private final Predicate<ComponentAst> alwaysEnabledComponentPredicate;
    private final Optional<Location> location;
    private final Predicate<ComponentAst> componentFilter;
    private final boolean isApplyStartPhaseRequested;
    private final boolean isKeepPrevious;
    private ArtifactAst minimalArtifactAst;
    private ArtifactAst artifactAstToInitialize;
    private Set<String> requestedLocations;

    private ComponentInitializationRequest(ArtifactAstDependencyGraph graph, ComponentInitializationState componentInitializationState, Predicate<ComponentAst> alwaysEnabledComponentPredicate, Predicate<ComponentAst> componentFilter, Optional<Location> location, boolean applyStartPhase, boolean keepPrevious) {
        this.graph = graph;
        this.componentInitializationState = componentInitializationState;
        this.alwaysEnabledComponentPredicate = alwaysEnabledComponentPredicate;
        this.location = location;
        this.componentFilter = componentFilter;
        this.isApplyStartPhaseRequested = applyStartPhase;
        this.isKeepPrevious = keepPrevious;
    }

    public Optional<Location> getLocation() {
        return this.location;
    }

    public boolean isApplyStartPhaseRequested() {
        return this.isApplyStartPhaseRequested;
    }

    public boolean isKeepPreviousRequested() {
        return this.isKeepPrevious;
    }

    public Set<String> getRequestedLocations() {
        if (this.requestedLocations == null) {
            this.requestedLocations = this.doGetRequestedLocations(this.getMinimalAst());
        }
        return this.requestedLocations;
    }

    public void validateRequestedAst(ArtifactAstValidator astValidator) throws ConfigurationException {
        astValidator.validate(this.getMinimalAst());
    }

    public ArtifactAst getFilteredAstToInitialize() {
        if (this.artifactAstToInitialize == null) {
            this.artifactAstToInitialize = this.doGetFilteredAstToInitialize(this.getMinimalAst());
        }
        return this.artifactAstToInitialize;
    }

    private static Predicate<ComponentAst> buildFilterFromComponentLocationFilter(LazyComponentInitializer.ComponentLocationFilter locationFilter) {
        return componentModel -> {
            if (componentModel.getLocation() != null) {
                return locationFilter.accept(componentModel.getLocation());
            }
            return false;
        };
    }

    private static Predicate<ComponentAst> buildFilterFromLocation(Location location) {
        return comp -> comp.getLocation() != null && comp.getLocation().getLocation().equals(location.toString());
    }

    private ArtifactAst getMinimalAst() {
        if (this.minimalArtifactAst == null) {
            this.minimalArtifactAst = this.doGetMinimalAst();
        }
        return this.minimalArtifactAst;
    }

    private ArtifactAst doGetMinimalAst() {
        Predicate<ComponentAst> minimalApplicationFilter = this.getFilterForMinimalArtifactAst();
        return this.graph.minimalArtifactFor(minimalApplicationFilter);
    }

    private Predicate<ComponentAst> getFilterForMinimalArtifactAst() {
        if (this.isKeepPreviousRequested()) {
            return this.componentFilter;
        }
        return this.componentFilter.or(this.alwaysEnabledComponentPredicate);
    }

    private Set<String> doGetRequestedLocations(ArtifactAst artifactAst) {
        return this.getLocation().map(location -> Collections.singleton(location.toString())).orElseGet(() -> artifactAst.filteredComponents(this.componentFilter).map(comp -> comp.getLocation().getLocation()).collect(Collectors.toSet()));
    }

    private ArtifactAst doGetFilteredAstToInitialize(ArtifactAst artifactAst) {
        if (this.isKeepPreviousRequested()) {
            return new FilteredArtifactAst(artifactAst, comp -> !this.componentInitializationState.isComponentAlreadyInitialized((ComponentAst)comp));
        }
        return artifactAst;
    }

    public static class Builder {
        private final ArtifactAstDependencyGraph graph;
        private final ComponentInitializationState componentInitializationState;
        private final Predicate<ComponentAst> alwaysEnabledComponentPredicate;
        private final boolean applyStartPhase;
        private final boolean keepPrevious;

        public Builder(ArtifactAstDependencyGraph graph, ComponentInitializationState componentInitializationState, Predicate<ComponentAst> alwaysEnabledComponentPredicate, boolean applyStartPhase, boolean keepPrevious) {
            this.graph = graph;
            this.componentInitializationState = componentInitializationState;
            this.alwaysEnabledComponentPredicate = alwaysEnabledComponentPredicate;
            this.applyStartPhase = applyStartPhase;
            this.keepPrevious = keepPrevious;
        }

        public ComponentInitializationRequest build(Location location) {
            return new ComponentInitializationRequest(this.graph, this.componentInitializationState, this.alwaysEnabledComponentPredicate, ComponentInitializationRequest.buildFilterFromLocation(location), Optional.of(location), this.applyStartPhase, this.keepPrevious);
        }

        public ComponentInitializationRequest build(Predicate<ComponentAst> componentFilter) {
            return new ComponentInitializationRequest(this.graph, this.componentInitializationState, this.alwaysEnabledComponentPredicate, componentFilter, Optional.empty(), this.applyStartPhase, this.keepPrevious);
        }

        public ComponentInitializationRequest build(LazyComponentInitializer.ComponentLocationFilter componentLocationFilter) {
            return this.build(ComponentInitializationRequest.buildFilterFromComponentLocationFilter(componentLocationFilter));
        }
    }

    @FunctionalInterface
    public static interface ArtifactAstValidator {
        public void validate(ArtifactAst var1) throws ConfigurationException;
    }
}

