/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.config.internal.bean.NotificationConfig;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.api.context.notification.NotificationsProvider;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class ServerNotificationManagerConfigurator
extends AbstractComponent
implements Initialisable {
    @Inject
    private MuleContext muleContext;
    @Inject
    private Registry registry;
    @Inject
    private ApplicationContext applicationContext;
    private Boolean dynamic;
    private List<NotificationConfig<? extends Notification, ? extends NotificationListener>> enabledNotifications = new ArrayList<NotificationConfig<? extends Notification, ? extends NotificationListener>>();
    private List<NotificationConfig<? extends Notification, ? extends NotificationListener>> disabledNotifications = new ArrayList<NotificationConfig<? extends Notification, ? extends NotificationListener>>();
    private Collection<ListenerSubscriptionPair> notificationListeners;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void initialise() throws InitialisationException {
        HashMap<String, Class<? extends Notification>> eventMap = new HashMap<String, Class<? extends Notification>>(NotificationConfig.EVENT_MAP);
        HashMap<String, Class<? extends NotificationListener>> interfaceMap = new HashMap<String, Class<? extends NotificationListener>>(NotificationConfig.INTERFACE_MAP);
        ServerNotificationManager notificationManager = this.populateNotificationTypeMappings(eventMap, interfaceMap);
        this.enableNotifications(notificationManager, eventMap, interfaceMap);
        this.disableNotifications(notificationManager, eventMap, interfaceMap);
        for (ListenerSubscriptionPair sub : this.getMergedListeners(notificationManager)) {
            if (!notificationManager.isListenerRegistered(sub.getListener())) {
                notificationManager.addListenerSubscriptionPair(sub);
                continue;
            }
            notificationManager.removeListener(sub.getListener());
            notificationManager.addListenerSubscriptionPair(sub);
        }
    }

    public ServerNotificationManager populateNotificationTypeMappings(Map<String, Class<? extends Notification>> eventMap, Map<String, Class<? extends NotificationListener>> interfaceMap) throws InitialisationException {
        HashMap<String, NotificationsProvider> providersMap = new HashMap<String, NotificationsProvider>();
        for (NotificationsProvider provider : this.registry.lookupAllByType(NotificationsProvider.class)) {
            for (Map.Entry entry : provider.getEventListenerMapping().entrySet()) {
                String notificationType = (String)entry.getKey();
                if (!notificationType.matches("[a-zA-Z]+:[A-Z\\-]+")) {
                    throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Notification '%s' declared in '%s' doesn't comply with the '[artifactID]:[NOTIFICATION-ID]' format", (Object[])new Object[]{notificationType, provider.toString()}), (Initialisable)this);
                }
                if (eventMap.containsKey(notificationType)) {
                    throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Notification '%s' declared in '%s' is already declared for another artifact in provider '%s'.", (Object[])new Object[]{notificationType, provider.toString(), eventMap.get(notificationType)}), (Initialisable)this);
                }
                eventMap.put(notificationType, (Class<? extends Notification>)((Pair)entry.getValue()).getFirst());
                interfaceMap.put(notificationType, (Class<? extends NotificationListener>)((Pair)entry.getValue()).getSecond());
                providersMap.put(notificationType, provider);
            }
        }
        ServerNotificationManager notificationManager = this.muleContext.getNotificationManager();
        if (this.dynamic != null) {
            notificationManager.setNotificationDynamic(this.dynamic.booleanValue());
        }
        return notificationManager;
    }

    private void disableNotifications(ServerNotificationManager notificationManager, Map<String, Class<? extends Notification>> eventMap, Map<String, Class<? extends NotificationListener>> interfaceMap) throws InitialisationException {
        for (NotificationConfig<? extends Notification, ? extends NotificationListener> disabledNotification : this.disabledNotifications) {
            Supplier<InitialisationException> noNotificationExceptionSupplier = () -> new InitialisationException(I18nMessageFactory.createStaticMessage((String)"No notification '%s' declared in this applications plugins to disable. Expected one of %s", (Object[])new Object[]{disabledNotification.getEventName(), eventMap.keySet().toString()}), (Initialisable)this);
            if (disabledNotification.isInterfaceExplicitlyConfigured()) {
                notificationManager.disableInterface(this.getInterfaceClass(disabledNotification, interfaceMap).orElseThrow(noNotificationExceptionSupplier));
            }
            if (!disabledNotification.isEventExplicitlyConfigured()) continue;
            notificationManager.disableType(this.getEventClass(disabledNotification, eventMap).orElseThrow(noNotificationExceptionSupplier));
        }
    }

    private void enableNotifications(ServerNotificationManager notificationManager, Map<String, Class<? extends Notification>> eventMap, Map<String, Class<? extends NotificationListener>> interfaceMap) throws InitialisationException {
        for (NotificationConfig<? extends Notification, ? extends NotificationListener> notification : this.enabledNotifications) {
            Supplier<InitialisationException> noNotificationExceptionSupplier = () -> new InitialisationException(I18nMessageFactory.createStaticMessage((String)"No notification '%s' declared in this applications plugins to enable. Expected one of %s", (Object[])new Object[]{notification.getEventName(), eventMap.keySet().toString()}), (Initialisable)this);
            notificationManager.addInterfaceToType(this.getInterfaceClass(notification, interfaceMap).orElseThrow(noNotificationExceptionSupplier), this.getEventClass(notification, eventMap).orElseThrow(noNotificationExceptionSupplier));
        }
    }

    private Optional<Class<? extends Notification>> getEventClass(NotificationConfig config, Map<String, Class<? extends Notification>> eventMap) {
        if (config.getEventClass() != null) {
            return Optional.of(config.getEventClass());
        }
        if (config.getEventName() != null) {
            return Optional.ofNullable(eventMap.get(config.getEventName()));
        }
        return Optional.ofNullable(eventMap.get(config.getInterfaceName()));
    }

    private Optional<Class<? extends NotificationListener>> getInterfaceClass(NotificationConfig config, Map<String, Class<? extends NotificationListener>> interfaceMap) {
        if (config.getInterfaceClass() != null) {
            return Optional.of(config.getInterfaceClass());
        }
        if (config.getInterfaceName() != null) {
            return Optional.of(interfaceMap.get(config.getInterfaceName()));
        }
        return Optional.ofNullable(interfaceMap.get(config.getEventName()));
    }

    protected Set<ListenerSubscriptionPair> getMergedListeners(ServerNotificationManager notificationManager) {
        HashSet<ListenerSubscriptionPair> mergedListeners = new HashSet<ListenerSubscriptionPair>();
        HashSet<ListenerSubscriptionPair> adhocListeners = new HashSet<ListenerSubscriptionPair>();
        for (String name : this.applicationContext.getBeanNamesForType(NotificationListener.class, false, true)) {
            adhocListeners.add(new ListenerSubscriptionPair((NotificationListener)this.applicationContext.getBean(name)));
        }
        if (this.notificationListeners != null) {
            mergedListeners.addAll(this.notificationListeners);
            for (ListenerSubscriptionPair candidate : adhocListeners) {
                boolean explicityDefined = false;
                for (ListenerSubscriptionPair explicitListener : this.notificationListeners) {
                    if (!candidate.getListener().equals(explicitListener.getListener())) continue;
                    explicityDefined = true;
                    break;
                }
                if (explicityDefined) continue;
                mergedListeners.add(candidate);
            }
        } else {
            mergedListeners.addAll(adhocListeners);
        }
        return mergedListeners;
    }

    public void setNotificationDynamic(boolean dynamic) {
        this.dynamic = new Boolean(dynamic);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEnabledNotifications(List<NotificationConfig<? extends Notification, ? extends NotificationListener>> enabledNotifications) {
        this.enabledNotifications = enabledNotifications;
    }

    public void setNotificationListeners(Collection<ListenerSubscriptionPair> notificationListeners) {
        this.notificationListeners = notificationListeners;
    }

    public void setDisabledNotifications(List<NotificationConfig<? extends Notification, ? extends NotificationListener>> disabledNotifications) {
        this.disabledNotifications = disabledNotifications;
    }

    static interface DisableNotificationTask {
        public void run() throws ClassNotFoundException;
    }
}

