/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl.model.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.app.declaration.internal.utils.Preconditions;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.metadata.DslElementIdHelper;
import org.mule.runtime.core.internal.locator.ComponentLocator;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheId;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheIdGenerator;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;

public class DslElementBasedValueProviderCacheIdGenerator
implements ValueProviderCacheIdGenerator<DslElementModel<?>> {
    private final ComponentLocator<DslElementModel<?>> locator;
    private static final String VALUE_PROVIDER = "ValueProvider";

    public DslElementBasedValueProviderCacheIdGenerator(ComponentLocator<DslElementModel<?>> locator) {
        this.locator = locator;
    }

    public Optional<ValueProviderCacheId> getIdForResolvedValues(DslElementModel<?> containerComponent, String parameterName) {
        return this.ifContainsParameter(containerComponent, parameterName).flatMap(ParameterModel::getValueProviderModel).flatMap(valueProviderModel -> this.resolveParametersInformation(containerComponent).flatMap(infoMap -> this.resolveId(containerComponent, (ValueProviderModel)valueProviderModel, (Map<String, ParameterModelInformation>)infoMap)));
    }

    public Optional<ValueProviderCacheId> getIdForResolvedValues(DslElementModel<?> containerComponent, String parameterName, String targetPath) {
        return this.ifContainsParameter(containerComponent, parameterName).flatMap(pm -> pm.getFieldValueProviderModels().stream().filter(fm -> Objects.equals(fm.getTargetSelector(), targetPath)).findAny()).flatMap(fieldModel -> this.resolveParametersInformation(containerComponent).flatMap(infoMap -> this.resolveId(containerComponent, (ValueProviderModel)fieldModel, (Map<String, ParameterModelInformation>)infoMap)));
    }

    private Optional<ParameterModel> ifContainsParameter(DslElementModel<?> containerComponent, String parameterName) {
        if (containerComponent.getModel() instanceof ParameterizedModel) {
            return ((ParameterizedModel)containerComponent.getModel()).getAllParameterModels().stream().filter(p -> Objects.equals(parameterName, p.getName())).findAny();
        }
        return Optional.empty();
    }

    private Optional<Map<String, ParameterModelInformation>> resolveParametersInformation(DslElementModel<?> containerComponent) {
        if (containerComponent.getModel() instanceof ParameterizedModel) {
            HashMap parametersDslMap = new HashMap();
            containerComponent.getContainedElements().stream().filter(containedElement -> containedElement.getModel() instanceof ParameterModel).map(x$0 -> new ParameterModelInformation((DslElementModel)x$0)).forEach(i -> parametersDslMap.put(((ParameterModelInformation)i).getParameterModel().getName(), i));
            return Optional.of(parametersDslMap);
        }
        return Optional.empty();
    }

    private Optional<ValueProviderCacheId> resolveId(DslElementModel<?> containerComponent, ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        if (containerComponent.getModel() instanceof ComponentModel) {
            return this.resolveForComponentModel(containerComponent, valueProviderModel, parameterModelsInformation);
        }
        return this.resolveForGlobalElement(containerComponent, valueProviderModel, parameterModelsInformation);
    }

    private Optional<ValueProviderCacheId> resolveForGlobalElement(DslElementModel<?> containerComponent, ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        LinkedList<ValueProviderCacheId> parts = new LinkedList<ValueProviderCacheId>();
        parts.addAll(this.resolveActingParameterIds(valueProviderModel, parameterModelsInformation));
        parts.add(this.resolveValueProviderId(valueProviderModel));
        parts.add(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)VALUE_PROVIDER).withHashValueFrom((Object)VALUE_PROVIDER)));
        String id = this.resolveDslTag(containerComponent).orElse(DslElementIdHelper.getSourceElementName(containerComponent));
        return Optional.of(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)id).withHashValueFrom((Object)this.resolveDslTagNamespace(containerComponent).orElse(id)).containing(parts)));
    }

    private Optional<ValueProviderCacheId> resolveForComponentModel(DslElementModel<?> containerComponent, ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        LinkedList<ValueProviderCacheId> parts = new LinkedList<ValueProviderCacheId>();
        parts.addAll(this.resolveActingParameterIds(valueProviderModel, parameterModelsInformation));
        parts.addAll(this.resolveIdForInjectedElements(containerComponent, valueProviderModel));
        parts.add(this.resolveValueProviderId(valueProviderModel));
        parts.add(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)VALUE_PROVIDER).withHashValueFrom((Object)VALUE_PROVIDER)));
        String id = this.resolveDslTag(containerComponent).orElse(DslElementIdHelper.getSourceElementName(containerComponent));
        return Optional.of(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)id).withHashValueFrom((Object)this.resolveDslTagNamespace(containerComponent).orElse(id)).containing(parts)));
    }

    private Optional<String> resolveDslTagNamespace(DslElementModel<?> containerComponent) {
        return containerComponent.getIdentifier().map(identifier -> identifier.getNamespace().toLowerCase());
    }

    private List<ValueProviderCacheId> resolveIdForInjectedElements(DslElementModel<?> containerComponent, ValueProviderModel valueProviderModel) {
        if (!valueProviderModel.requiresConfiguration() && !valueProviderModel.requiresConnection()) {
            return Collections.emptyList();
        }
        LinkedList<ValueProviderCacheId> injectableIds = new LinkedList<ValueProviderCacheId>();
        Optional configDslElementModel = DslElementIdHelper.resolveConfigName(containerComponent).flatMap(config -> this.locator.get(Location.builder().globalName(config).build()));
        if (configDslElementModel.isPresent() && ((DslElementModel)configDslElementModel.get()).getModel() instanceof ConfigurationModel) {
            if (valueProviderModel.requiresConfiguration()) {
                this.resolveIdForInjectedElement((DslElementModel)configDslElementModel.get()).ifPresent(id -> injectableIds.add(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)"config: ").containing(new ValueProviderCacheId[]{id}))));
            }
            if (valueProviderModel.requiresConnection()) {
                ((DslElementModel)configDslElementModel.get()).getContainedElements().stream().filter(nested -> nested.getModel() instanceof ConnectionProviderModel).forEach(connectionProvider -> this.resolveIdForInjectedElement((DslElementModel<?>)connectionProvider).ifPresent(id -> injectableIds.add(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)"connection: ").containing(new ValueProviderCacheId[]{id})))));
            }
        }
        return injectableIds;
    }

    Optional<ValueProviderCacheId> resolveIdForInjectedElement(DslElementModel<?> injectedElement) {
        if (!(injectedElement.getModel() instanceof EnrichableModel)) {
            return Optional.empty();
        }
        LinkedList parts = new LinkedList();
        List parametersRequiredForMetadata = ((EnrichableModel)injectedElement.getModel()).getModelProperty(RequiredForMetadataModelProperty.class).map(RequiredForMetadataModelProperty::getRequiredParameters).orElse(Collections.emptyList());
        this.resolveParametersInformation(injectedElement).ifPresent(pi -> parametersRequiredForMetadata.forEach(requiredParameter -> {
            if (pi.containsKey(requiredParameter)) {
                ParameterModelInformation parameterInfo = (ParameterModelInformation)pi.get(requiredParameter);
                this.resolveParameterId(parameterInfo.getParameterDslElementModel()).ifPresent(parts::add);
            }
        }));
        if (parts.isEmpty()) {
            return Optional.empty();
        }
        String sourceElementName = DslElementIdHelper.sourceElementNameFromSimpleValue(injectedElement);
        return Optional.of(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)sourceElementName).withHashValueFrom((Object)sourceElementName).containing(parts)));
    }

    private ValueProviderCacheId resolveValueProviderId(ValueProviderModel valueProviderModel) {
        return ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)("providerId: " + valueProviderModel.getProviderId())).withHashValueFrom((Object)valueProviderModel.getProviderId()));
    }

    private List<ValueProviderCacheId> resolveActingParameterIds(ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        return valueProviderModel.getParameters().stream().map(ActingParameterModel::getExtractionExpression).map(ValueProviderUtils::getParameterNameFromExtractionExpression).filter(parameterModelsInformation::containsKey).map(parameterModelsInformation::get).map(rec$ -> ((ParameterModelInformation)rec$).getParameterDslElementModel()).map(dsl -> this.resolveParameterId((DslElementModel<?>)dsl).orElse(null)).collect(Collectors.toList());
    }

    private Optional<String> resolveDslTag(DslElementModel<?> elementModel) {
        return elementModel.getIdentifier().map(Object::toString);
    }

    private Optional<ValueProviderCacheId> resolveParameterId(DslElementModel<?> parameterModel) {
        return parameterModel.getValue().map(v -> DslElementIdHelper.resolveSimpleValue(parameterModel, this.locator).map(either -> (ValueProviderCacheId)either.reduce(l -> this.resolveIdRecursively((DslElementModel<?>)l).orElse(null), r -> ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)DslElementIdHelper.sourceElementNameFromSimpleValue(parameterModel)).withHashValueFrom(v))))).orElseGet(() -> this.resolveIdRecursively(parameterModel));
    }

    private Optional<ValueProviderCacheId> resolveIdRecursively(DslElementModel<?> element) {
        if (element.getValue().isPresent()) {
            return Optional.empty();
        }
        String id = this.resolveDslTag(element).orElse(DslElementIdHelper.getSourceElementName(element));
        ValueProviderCacheId.ValueProviderCacheIdBuilder vpIdBuilder = ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)id).withHashValueFrom((Object)id);
        element.getContainedElements().stream().map(this::resolveParameterId).forEach(resolvedId -> resolvedId.ifPresent(xva$0 -> vpIdBuilder.containing(new ValueProviderCacheId[]{xva$0})));
        return Optional.of(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)vpIdBuilder));
    }

    private static class ParameterModelInformation {
        private final ParameterModel parameterModel;
        private final DslElementModel<?> parameterDslElementModel;

        private ParameterModelInformation(DslElementModel<?> dslElementModel) {
            Preconditions.checkArgument((boolean)(dslElementModel.getModel() instanceof ParameterModel), (String)"A ParameterModel is expected");
            this.parameterModel = (ParameterModel)dslElementModel.getModel();
            this.parameterDslElementModel = dslElementModel;
        }

        private ParameterModel getParameterModel() {
            return this.parameterModel;
        }

        private DslElementModel<?> getParameterDslElementModel() {
            return this.parameterDslElementModel;
        }
    }
}

