/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import com.github.benmanes.caffeine.cache.LoadingCache;
import jakarta.inject.Named;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;

class InjectParamsFromContextServiceUtils {
    public static final String MANY_CANDIDATES_ERROR_MSG_TEMPLATE = "More than one invocation candidate for method '%s' in service '%s'";
    public static final String NO_OBJECT_FOUND_FOR_PARAM = "No object found in the registry for parameter '%s' of method '%s' in service '%s'";

    private InjectParamsFromContextServiceUtils() {
    }

    static Object calculateAugmentedArgForParamerter(Parameter parameter, LoadingCache<String, Optional<?>> lookupByNameCache, LoadingCache<Class<?>, Collection<?>> lookupAllByTypeCache, Method injectable, String serviceName) {
        Named named = parameter.getAnnotation(Named.class);
        if (named != null) {
            return ((Optional)lookupByNameCache.get((Object)named.value())).orElseThrow(() -> new IllegalDependencyInjectionException(String.format(NO_OBJECT_FOUND_FOR_PARAM, parameter.getName(), injectable.getName(), serviceName)));
        }
        javax.inject.Named javaxNamed = parameter.getAnnotation(javax.inject.Named.class);
        if (javaxNamed != null) {
            return ((Optional)lookupByNameCache.get((Object)javaxNamed.value())).orElseThrow(() -> new IllegalDependencyInjectionException(String.format(NO_OBJECT_FOUND_FOR_PARAM, parameter.getName(), injectable.getName(), serviceName)));
        }
        return ((Collection)lookupAllByTypeCache.get(parameter.getType())).iterator().next();
    }

    static Method resolveInjectableMethodFor(Method method, Method serviceImplMethod, LoadingCache<Class<?>, Collection<?>> lookupAllByTypeCache, Method candidate, String serviceName) {
        if (Modifier.isPublic(serviceImplMethod.getModifiers()) && serviceImplMethod.getName().equals(method.getName()) && (((jakarta.inject.Inject[])serviceImplMethod.getAnnotationsByType(jakarta.inject.Inject.class)).length > 0 || ((Inject[])serviceImplMethod.getAnnotationsByType(Inject.class)).length > 0) && InjectParamsFromContextServiceUtils.equivalentParams(method.getParameters(), serviceImplMethod.getParameters(), lookupAllByTypeCache)) {
            if (!(candidate == null || candidate.getName().equals(serviceImplMethod.getName()) && Arrays.deepEquals(candidate.getParameterTypes(), serviceImplMethod.getParameterTypes()))) {
                throw new IllegalDependencyInjectionException(String.format(MANY_CANDIDATES_ERROR_MSG_TEMPLATE, method.getName(), serviceName));
            }
            return serviceImplMethod;
        }
        return candidate;
    }

    private static boolean equivalentParams(Parameter[] invocationParams, Parameter[] serviceImplParams, LoadingCache<Class<?>, Collection<?>> lookupAllByTypeCache) {
        if (serviceImplParams.length < invocationParams.length) {
            return false;
        }
        int i = 0;
        for (Parameter invocationParam : invocationParams) {
            if (!serviceImplParams[i].getType().equals(invocationParam.getType())) {
                return false;
            }
            ++i;
        }
        for (int j = i; j < serviceImplParams.length; ++j) {
            if (serviceImplParams[j].isAnnotationPresent(Named.class) || serviceImplParams[j].isAnnotationPresent(javax.inject.Named.class) || !((Collection)lookupAllByTypeCache.get(serviceImplParams[j].getType())).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

