/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.lazy;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class TrackingPostProcessor
implements BeanPostProcessor {
    private final Set<String> trackingOrderedSet = new LinkedHashSet<String>();
    private final Set<String> currentTrackingOrderedSet = new LinkedHashSet<String>();
    private boolean tracking = false;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.tracking && !StringUtils.isBlank((CharSequence)beanName)) {
            this.currentTrackingOrderedSet.add(beanName);
        }
        return bean;
    }

    public Set<String> getBeansTracked() {
        return Set.copyOf(this.trackingOrderedSet);
    }

    public List<String> getBeansTrackedInOrder() {
        return List.copyOf(this.trackingOrderedSet);
    }

    public void startTracking() {
        this.tracking = true;
        this.currentTrackingOrderedSet.clear();
    }

    public void stopTracking() {
        this.tracking = false;
        this.currentTrackingOrderedSet.clear();
    }

    public void commitOnly(Collection<String> beanNames) {
        this.tracking = false;
        this.currentTrackingOrderedSet.stream().filter(beanNames::contains).forEach(this.trackingOrderedSet::add);
        this.currentTrackingOrderedSet.clear();
    }

    public void reset() {
        this.trackingOrderedSet.clear();
        this.currentTrackingOrderedSet.clear();
        this.tracking = false;
    }
}

