/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.AnnotatedObject;

public class SpringConfigurationComponentLocator
implements ConfigurationComponentLocator {
    private Map<String, AnnotatedObject> componentsMap = new HashMap<String, AnnotatedObject>();

    public void addComponent(AnnotatedObject component) {
        this.componentsMap.put(component.getLocation().getLocation(), component);
    }

    public Optional<AnnotatedObject> find(Location location) {
        return Optional.ofNullable(this.componentsMap.get(location.toString()));
    }

    public List<AnnotatedObject> find(ComponentIdentifier componentIdentifier) {
        return this.componentsMap.values().stream().filter(component -> component.getLocation().getComponentIdentifier().getIdentifier().equals(componentIdentifier)).collect(Collectors.toList());
    }

    public List<AnnotatedObject> findAll() {
        return Collections.unmodifiableList(new ArrayList<AnnotatedObject>(this.componentsMap.values()));
    }
}

