/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public abstract class AnnotatedObjectFactoryBean<B extends AnnotatedObject>
extends AbstractFactoryBean<B>
implements AnnotatedObject {
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();

    public final Object getAnnotation(QName qName) {
        return this.annotations.get(qName);
    }

    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public final synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }

    public B createInstance() throws Exception {
        B annotatedInstance = this.doCreateInstance();
        annotatedInstance.setAnnotations(this.getAnnotations());
        return annotatedInstance;
    }

    protected abstract B doCreateInstance() throws Exception;
}

