/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class ConstantFactoryBean<T>
extends AbstractAnnotatedObject
implements FactoryBean<T>,
MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstantFactoryBean.class);
    private final T value;

    public ConstantFactoryBean(T value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        this.value = value;
    }

    public T getObject() throws Exception {
        if (this.value instanceof AnnotatedObject) {
            ((AnnotatedObject)this.value).setAnnotations(this.getAnnotations());
        }
        return this.value;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return this.value.getClass();
    }

    public void setMuleContext(MuleContext context) {
        if (this.value instanceof MuleContextAware) {
            ((MuleContextAware)this.value).setMuleContext(context);
        }
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.value);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.value);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.value);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.value, (Logger)LOGGER);
    }
}

