/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.spring;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlCustomAttributeHandler;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.routing.MessageFilter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

class FilterReferenceBeanDefinitionCreator
extends BeanDefinitionCreator {
    private static final ComponentIdentifier FILTER_REFERENCE_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("filter").build();

    FilterReferenceBeanDefinitionCreator() {
    }

    @Override
    public boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        ComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        if (componentModel.getIdentifier().equals(FILTER_REFERENCE_IDENTIFIER)) {
            if (XmlCustomAttributeHandler.from(componentModel).getNode().getParentNode().getNodeName().equals("message-filter")) {
                componentModel.setType(Filter.class);
                componentModel.setBeanReference((BeanReference)new RuntimeBeanReference(componentModel.getParameters().get("ref")));
            } else {
                componentModel.setType(Processor.class);
                BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(MessageFilter.class);
                beanDefinitionBuilder.addConstructorArgReference(componentModel.getParameters().get("ref"));
                componentModel.setBeanDefinition((BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
            }
            return true;
        }
        return false;
    }
}

