/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.spring;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.MessageRouter;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.OutboundRouter;
import org.mule.runtime.core.api.routing.SelectiveRouter;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.exception.ErrorHandler;
import org.mule.runtime.core.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.routing.AbstractSelectiveRouter;
import org.mule.runtime.core.source.scheduler.DefaultSchedulerMessageSource;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;

public class ComponentModelHelper {
    public static TypedComponentIdentifier.ComponentType resolveComponentType(ComponentModel componentModel) {
        if (ComponentModelHelper.isMessageSource(componentModel)) {
            return TypedComponentIdentifier.ComponentType.SOURCE;
        }
        if (ComponentModelHelper.isErrorHandler(componentModel)) {
            return TypedComponentIdentifier.ComponentType.ERROR_HANDLER;
        }
        if (ComponentModelHelper.isTemplateOnErrorHandler(componentModel)) {
            return TypedComponentIdentifier.ComponentType.ON_ERROR;
        }
        if (ComponentModelHelper.isFlow(componentModel)) {
            return TypedComponentIdentifier.ComponentType.FLOW;
        }
        if (ComponentModelHelper.isProcessor(componentModel)) {
            if (ComponentModelHelper.isInterceptingProcessor(componentModel)) {
                return TypedComponentIdentifier.ComponentType.INTERCEPTING;
            }
            if (ComponentModelHelper.isRouterProcessor(componentModel)) {
                return TypedComponentIdentifier.ComponentType.ROUTER;
            }
            return TypedComponentIdentifier.ComponentType.PROCESSOR;
        }
        return TypedComponentIdentifier.ComponentType.UNKNOWN;
    }

    public static boolean isAnnotatedObject(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, AnnotatedObject.class);
    }

    private static boolean isRouterProcessor(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, OutboundRouter.class) || ComponentModelHelper.isOfType(componentModel, SelectiveRouter.class) || ComponentModelHelper.isOfType(componentModel, MessageRouter.class);
    }

    private static boolean isInterceptingProcessor(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, InterceptingMessageProcessor.class);
    }

    public static boolean isProcessor(ComponentModel componentModel) {
        if (componentModel.getIdentifier().getName().equals("flow-ref")) {
            return true;
        }
        return ComponentModelHelper.isOfType(componentModel, Processor.class) || ComponentModelHelper.isOfType(componentModel, InterceptingMessageProcessor.class) || ComponentModelHelper.isOfSmartConnectorType(componentModel);
    }

    private static boolean isOfSmartConnectorType(ComponentModel componentModel) {
        return componentModel.getType() == null;
    }

    public static boolean isMessageSource(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, MessageSource.class);
    }

    public static boolean isErrorHandler(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, ErrorHandler.class);
    }

    public static boolean isPoll(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, DefaultSchedulerMessageSource.class);
    }

    public static boolean isTemplateOnErrorHandler(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, TemplateOnErrorHandler.class);
    }

    public static boolean isFlow(ComponentModel componentModel) {
        return componentModel.getIdentifier().equals(ApplicationModel.FLOW_IDENTIFIER);
    }

    public static boolean isSubflow(ComponentModel componentModel) {
        return componentModel.getIdentifier().equals(ApplicationModel.SUBFLOW_IDENTIFIER);
    }

    private static boolean isOfType(ComponentModel componentModel, Class type) {
        Class<?> componentModelType = componentModel.getType();
        if (componentModelType == null) {
            return false;
        }
        return CommonBeanDefinitionCreator.areMatchingTypes(type, componentModelType);
    }

    public static void addAnnotation(QName annotationKey, Object annotationValue, ComponentModel componentModel) {
        Map<QName, Object> annotations;
        if (!ComponentModelHelper.isAnnotatedObject(componentModel) && !componentModel.getIdentifier().getName().equals("flow-ref")) {
            return;
        }
        BeanDefinition beanDefinition = componentModel.getBeanDefinition();
        if (beanDefinition == null) {
            return;
        }
        PropertyValue propertyValue = beanDefinition.getPropertyValues().getPropertyValue("annotations");
        if (propertyValue == null) {
            annotations = new HashMap();
            propertyValue = new PropertyValue("annotations", annotations);
            componentModel.getBeanDefinition().getPropertyValues().addPropertyValue(propertyValue);
        } else {
            annotations = (Map)propertyValue.getValue();
        }
        annotations.put(annotationKey, annotationValue);
    }

    public static <T> Optional<T> getAnnotation(QName annotationKey, ComponentModel componentModel) {
        if (componentModel.getBeanDefinition() == null) {
            return Optional.empty();
        }
        PropertyValue propertyValue = componentModel.getBeanDefinition().getPropertyValues().getPropertyValue("annotations");
        if (propertyValue == null) {
            return Optional.empty();
        }
        Map annotations = (Map)propertyValue.getValue();
        return Optional.ofNullable(annotations.get(annotationKey));
    }

    public static boolean isRouter(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, MessageRouter.class) || ComponentModelHelper.isOfType(componentModel, AbstractSelectiveRouter.class);
    }
}

