/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.test.discoverer;

import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.manager.DefaultServiceRegistry;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ServiceRegistryTestCase
extends AbstractMuleTestCase {
    private final DefaultServiceRegistry serviceRegistry = new DefaultServiceRegistry();

    @Test
    public void injectsDependencies() throws Exception {
        FooService service = this.mockFooService();
        InjectableServiceProvider serviceProvider = new InjectableServiceProvider();
        this.serviceRegistry.inject((ServiceProvider)serviceProvider);
        MatcherAssert.assertThat((Object)serviceProvider.fooService, (Matcher)Is.is((Object)service));
    }

    private FooService mockFooService() {
        FooService service = (FooService)Mockito.mock(FooService.class);
        this.serviceRegistry.register((Service)service, FooService.class);
        return service;
    }

    @Test(expected=ServiceResolutionError.class)
    public void detectsMissingDependency() throws Exception {
        InjectableServiceProvider serviceProvider = new InjectableServiceProvider();
        this.serviceRegistry.inject((ServiceProvider)serviceProvider);
    }

    public static class NoInjectableServiceProvider
    implements ServiceProvider {
        @Inject
        private String message;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }
    }

    public static class InjectableServiceProvider
    implements ServiceProvider {
        @Inject
        private FooService fooService;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }
    }

    public static interface FooService
    extends Service {
    }
}

