/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.api.artifact;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.container.api.MuleContainerClassLoaderWrapper;
import org.mule.runtime.jpms.api.JpmsUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.api.artifact.ServiceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceModuleLayerFactory
extends ServiceClassLoaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceModuleLayerFactory.class);
    private static final Set<String> SERVICE_MODULE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("org.mule.service.", "com.mulesoft.mule.service."));
    private static final String SCHEDULER_SERVICE_MODULE_NAME = "org.mule.service.scheduler";
    private static final String CLASSLOADER_SERVICE_JPMS_MODULE_LAYER_DATAWEAVE = "mule.classloader.service.jpmsModuleLayer.dataWeave";

    ServiceModuleLayerFactory() {
    }

    @Override
    @Deprecated
    public ArtifactClassLoader create(String artifactId, ServiceDescriptor descriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        if (artifactId.equals("service/DataWeave service") && !Boolean.getBoolean(System.getProperty(CLASSLOADER_SERVICE_JPMS_MODULE_LAYER_DATAWEAVE, "false"))) {
            return new MuleArtifactClassLoader(artifactId, (ArtifactDescriptor)descriptor, descriptor.getClassLoaderConfiguration().getUrls(), parent, lookupPolicy);
        }
        LOGGER.debug(" >> Creating ModuleLayer for service: '" + artifactId + "'...");
        ModuleLayer artifactLayer = JpmsUtils.createModuleLayer((URL[])descriptor.getClassLoaderConfiguration().getUrls(), (ClassLoader)parent, Optional.empty(), (boolean)true, (boolean)true);
        String serviceModuleName = artifactLayer.modules().stream().filter(module -> SERVICE_MODULE_NAME_PREFIXES.stream().anyMatch(module.getName()::startsWith)).findAny().orElse(artifactLayer.modules().iterator().next()).getName();
        if (serviceModuleName.equals(SCHEDULER_SERVICE_MODULE_NAME)) {
            JpmsUtils.openToModule((ModuleLayer)artifactLayer, (String)serviceModuleName, (String)"java.base", Collections.singletonList("java.lang"));
        }
        return new MuleServiceClassLoader(artifactId, descriptor, new URL[0], artifactLayer.findLoader(serviceModuleName), lookupPolicy);
    }

    @Override
    public ArtifactClassLoader create(String artifactId, ServiceDescriptor descriptor, MuleContainerClassLoaderWrapper containerClassLoader) {
        return this.create(artifactId, descriptor, containerClassLoader.getContainerClassLoader().getClassLoader(), containerClassLoader.getContainerClassLoaderLookupPolicy());
    }

    private static final class MuleServiceClassLoader
    extends MuleArtifactClassLoader {
        private MuleServiceClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
            super(artifactId, artifactDescriptor, urls, parent, lookupPolicy);
        }
    }
}

