/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.reboot.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.mule.runtime.module.reboot.internal.DefaultMuleClassPathConfig;
import org.mule.runtime.module.reboot.internal.MuleContainer;
import org.mule.runtime.module.reboot.internal.MuleContainerSystemClassLoader;

public class MuleContainerFactory {
    private static final String CLASSNAME_MULE_CONTAINER = "org.mule.runtime.module.launcher.DefaultMuleContainer";
    private final String muleHomeDirectoryPropertyName;
    private final String muleBaseDirectoryPropertyName;

    public MuleContainerFactory(String muleHomeDirectoryPropertyName, String muleBaseDirectoryPropertyName) {
        this.muleHomeDirectoryPropertyName = muleHomeDirectoryPropertyName;
        this.muleBaseDirectoryPropertyName = muleBaseDirectoryPropertyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleContainer create(String[] args) throws Exception {
        ClassLoader muleSystemCl = this.createContainerSystemClassLoader(this.lookupMuleHome(), this.lookupMuleBase());
        Class<?> muleClass = muleSystemCl.loadClass(CLASSNAME_MULE_CONTAINER);
        Constructor<?> c = muleClass.getConstructor(String[].class);
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(muleSystemCl);
        try {
            MuleContainer muleContainer = (MuleContainer)c.newInstance(new Object[]{args});
            return muleContainer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    protected ClassLoader createContainerSystemClassLoader(File muleHome, File muleBase) {
        DefaultMuleClassPathConfig config = new DefaultMuleClassPathConfig(muleHome, muleBase);
        return new MuleContainerSystemClassLoader(config);
    }

    private File lookupMuleHome() throws IOException {
        return this.lookupMuleDirectoryLocation(this.muleHomeDirectoryPropertyName, "%MULE_HOME%");
    }

    private File lookupMuleBase() throws IOException {
        return this.lookupMuleDirectoryLocation(this.muleBaseDirectoryPropertyName, "%MULE_BASE%");
    }

    private File lookupMuleDirectoryLocation(String muleDirectoryLocationPropertyName, String placeholderForNullValue) throws IOException {
        File muleBase = null;
        String muleBaseVar = System.getProperty(muleDirectoryLocationPropertyName);
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals(placeholderForNullValue)) {
            muleBase = new File(muleBaseVar).getCanonicalFile();
        }
        this.validateMuleDirectoryLocation(muleDirectoryLocationPropertyName, muleBase);
        return muleBase;
    }

    private void validateMuleDirectoryLocation(String muleDirectoryLocationPropertyName, File muleDirectoryLocation) throws IllegalArgumentException {
        if (muleDirectoryLocation == null) {
            throw new IllegalArgumentException("The system property " + muleDirectoryLocationPropertyName + " is not set.");
        }
        if (!muleDirectoryLocation.exists()) {
            throw new IllegalArgumentException("The system property " + muleDirectoryLocationPropertyName + " does not contain a valid directory (" + muleDirectoryLocation.getAbsolutePath() + ").");
        }
        if (!muleDirectoryLocation.isDirectory()) {
            throw new IllegalArgumentException("The system property " + muleDirectoryLocationPropertyName + " does not contain a valid directory (" + muleDirectoryLocation.getAbsolutePath() + ").");
        }
    }
}

