/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.reboot;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.runtime.jpms.api.JpmsUtils;
import org.mule.runtime.module.reboot.internal.MuleContainerFactory;
import org.mule.runtime.module.reboot.internal.MuleContainerWrapper;
import org.mule.runtime.module.reboot.internal.MuleContainerWrapperProvider;
import org.mule.runtime.module.reboot.internal.MuleLog4jConfigurer;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class MuleContainerBootstrap {
    public static final String MULE_HOME_DIRECTORY_PROPERTY = "mule.home";
    public static final String MULE_BASE_DIRECTORY_PROPERTY = "mule.base";
    public static final String[][] CLI_OPTIONS = new String[][]{{"main", "true", "Main Class"}, {"production", "false", "Modify the system class loader for production use (as in Mule 2.x)"}, {"version", "false", "Show product and version information"}};

    public static void main(String[] args) throws Exception {
        CommandLine commandLine;
        MuleContainerFactory muleContainerFactory = new MuleContainerFactory(MULE_HOME_DIRECTORY_PROPERTY, MULE_BASE_DIRECTORY_PROPERTY);
        MuleContainerWrapper muleContainerWrapper = MuleContainerWrapperProvider.getMuleContainerWrapper();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        JpmsUtils.validateNoBootModuleLayerTweaking();
        try {
            commandLine = MuleContainerBootstrap.parseCommandLine(args);
        }
        catch (Exception ex) {
            muleContainerWrapper.haltAndCatchFire(1, ex.getMessage());
            return;
        }
        muleContainerWrapper.addBootstrapConfigurer(new MuleLog4jConfigurer());
        muleContainerWrapper.configureAndStart(muleContainerFactory, commandLine);
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        for (String[] element : CLI_OPTIONS) {
            options.addOption(element[0], "true".equalsIgnoreCase(element[1]), element[2]);
        }
        return new BasicParser().parse(options, args, true);
    }
}

