/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.observability;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.MapConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfigurationFileFinder;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfigurationPropertyResolver;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;

public abstract class AbstractFileObservabilitySignalConfiguration
implements ObservabilitySignalConfiguration {
    private static final ObjectMapper configFileMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String UNSUPPORTED_TYPE_ERROR_MESSAGE = "Configuration key '%s' has an unsupported type %s. Only string values are allowed.";
    private static final String OPEN_TELEMETRY_ARTIFACT_LEVEL_CONFIGURATION_PROPERTIES = "OpenTelemetry artifact level configuration properties. Artifact name: %s.";
    private final ConfigurationPropertiesResolver systemPropertiesOnlyConfigurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), (ConfigurationPropertiesProvider)new SystemPropertiesConfigurationProvider());
    private final ObservabilitySignalConfigurationPropertyResolver observabilitySignalRuntimeLevelConfigurationPropertyResolver = arg_0 -> ((ConfigurationPropertiesResolver)this.systemPropertiesOnlyConfigurationPropertiesResolver).apply(arg_0);
    private final ObservabilitySignalConfigurationPropertyResolver observabilitySignalArtifactLevelConfigurationPropertyResolver;
    private boolean isPropertiesInitialized = false;
    private JsonNode configuration;
    private File configurationFile;
    private final String artifactId;
    private final ObservabilitySignalConfigurationFileFinder artifactResourceFinder;

    protected AbstractFileObservabilitySignalConfiguration(ObservabilitySignalConfigurationFileFinder artifactResourceFinder, DeployableArtifactDescriptor deployableArtifactDescriptor) {
        this(artifactResourceFinder, AbstractFileObservabilitySignalConfiguration.getArtifactDeploymentProperties(deployableArtifactDescriptor), AbstractFileObservabilitySignalConfiguration.getArtifactId(deployableArtifactDescriptor));
    }

    protected AbstractFileObservabilitySignalConfiguration(ObservabilitySignalConfigurationFileFinder artifactResourceFinder, Properties artifactDeploymentProperties, String artifactId) {
        this.artifactId = artifactId;
        this.observabilitySignalArtifactLevelConfigurationPropertyResolver = AbstractFileObservabilitySignalConfiguration.getArtifactLevelConfigurationPropertyResolver(artifactDeploymentProperties, artifactId);
        this.artifactResourceFinder = artifactResourceFinder;
    }

    @Override
    public String getStringValue(String configurationKey) {
        this.initialiseIfNecessary();
        String configurationValue = this.readStringFromConfigOrSystemProperty(configurationKey);
        return this.resolveConfigurationProperty(configurationKey, configurationValue);
    }

    @Override
    public List<String> getStringListValue(String configurationKey) {
        this.initialiseIfNecessary();
        if (this.configuration == null) {
            return null;
        }
        return this.readStringListFromConfig(configurationKey);
    }

    @Override
    public Path getPathValue(String key, Path defaultValue) {
        return this.getAbsolutePath(ObservabilitySignalConfiguration.super.getPathValue(key, defaultValue));
    }

    protected abstract void onConfigurationFileNotFound();

    protected abstract void onConfigurationFileLoadError(Exception var1, File var2);

    protected abstract String getSignalConfigurationFileName();

    protected abstract Path getSignalConfigurationFileDirectoryPath();

    protected static File findArtifactConfigFile(ClassLoader executionClassloader, String configFilePath) {
        try {
            URL resource = executionClassloader.getResource(configFilePath);
            return resource != null ? new File(resource.toURI()) : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected File getConfigurationFile() {
        return this.configurationFile;
    }

    protected String getConfigurationFileLocations() {
        if (AbstractFileObservabilitySignalConfiguration.isApplicationLevelConfigurable()) {
            return String.format("at at both '%s' artifact resources and the '%s' configuration path", this.artifactId, this.getSignalConfigurationFileDirectoryPath());
        }
        return String.format("at the '%s' configuration path", this.getSignalConfigurationFileDirectoryPath());
    }

    protected static boolean isApplicationLevelConfigurable() {
        return Boolean.getBoolean("mule.observability.configuration.enableConfigurationAtApplicationLevel") || Boolean.getBoolean("mule.tracing.configuration.enableTracerConfigurationAtApplicationLevel");
    }

    protected abstract boolean isArtifactLevelProperty(String var1);

    protected void initialise() {
        this.loadConfiguration();
    }

    private static String getArtifactId(DeployableArtifactDescriptor deployableArtifactDescriptor) {
        return deployableArtifactDescriptor != null ? deployableArtifactDescriptor.getName() : "mule-runtime";
    }

    private static Properties getArtifactDeploymentProperties(DeployableArtifactDescriptor deployableArtifactDescriptor) {
        return deployableArtifactDescriptor != null ? deployableArtifactDescriptor.getDeploymentProperties().orElse(new Properties()) : new Properties();
    }

    private static ObservabilitySignalConfigurationPropertyResolver getArtifactLevelConfigurationPropertyResolver(final Properties configurationProperties, final String artifactId) {
        return new ObservabilitySignalConfigurationPropertyResolver(){
            final ConfigurationPropertiesResolver configurationPropertiesResolver;
            {
                this.configurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(new DefaultConfigurationPropertiesResolver(Optional.empty(), (ConfigurationPropertiesProvider)new SystemPropertiesConfigurationProvider())), (ConfigurationPropertiesProvider)new MapConfigurationPropertiesProvider(AbstractFileObservabilitySignalConfiguration.filterStringConfigurationProperties(configurationProperties), String.format(AbstractFileObservabilitySignalConfiguration.OPEN_TELEMETRY_ARTIFACT_LEVEL_CONFIGURATION_PROPERTIES, artifactId)));
            }

            @Override
            public String resolve(String propertyReference) {
                return this.configurationPropertiesResolver.apply(propertyReference);
            }
        };
    }

    private static Map<String, String> filterStringConfigurationProperties(Properties configurationProperties) {
        HashMap<String, String> stringConfigurationProperties = new HashMap<String, String>(configurationProperties.stringPropertyNames().size());
        for (String key : configurationProperties.stringPropertyNames()) {
            stringConfigurationProperties.put(key, configurationProperties.getProperty(key));
        }
        return stringConfigurationProperties;
    }

    private String resolveConfigurationProperty(String configurationKey, String configurationValue) {
        if (this.isArtifactLevelProperty(configurationKey)) {
            return this.observabilitySignalArtifactLevelConfigurationPropertyResolver.resolve(configurationValue);
        }
        return this.observabilitySignalRuntimeLevelConfigurationPropertyResolver.resolve(configurationValue);
    }

    private void initialiseIfNecessary() {
        if (!this.isPropertiesInitialized) {
            this.isPropertiesInitialized = true;
            this.initialise();
        }
    }

    private void loadConfiguration() {
        try {
            this.configurationFile = this.getSignalConfigurationFromArtifactOrFromFileSystem();
            if (this.configurationFile.exists()) {
                this.parseConfiguration(this.configurationFile);
            } else {
                this.onConfigurationFileNotFound();
            }
        }
        catch (Exception configurationException) {
            this.onConfigurationFileLoadError(configurationException, this.configurationFile);
        }
    }

    private File getSignalConfigurationFromArtifactOrFromFileSystem() {
        return this.getSignalConfigurationResourceFromArtifactOrFromFileSystem(Path.of(this.getSignalConfigurationFileName(), new String[0]));
    }

    private File getSignalConfigurationResourceFromArtifactOrFromFileSystem(Path path) {
        File configurationFile = null;
        if (AbstractFileObservabilitySignalConfiguration.isApplicationLevelConfigurable()) {
            configurationFile = this.artifactResourceFinder.getResource(path.toString());
        }
        return configurationFile != null ? configurationFile : this.getSignalConfigurationFileDirectoryPath().resolve(path).toFile();
    }

    private String readStringFromConfigOrSystemProperty(String key) {
        if (this.configuration == null) {
            return System.getProperty(key);
        }
        JsonNode node = AbstractFileObservabilitySignalConfiguration.readFromConfiguration(key, this.configuration);
        if (node == null || node.isNull()) {
            return null;
        }
        if (!node.isValueNode()) {
            throw new IllegalArgumentException(String.format(UNSUPPORTED_TYPE_ERROR_MESSAGE, key, node.getNodeType()));
        }
        String value = node.asText();
        return !value.isEmpty() ? value : null;
    }

    protected List<String> readStringListFromConfig(String key) {
        JsonNode node = AbstractFileObservabilitySignalConfiguration.readFromConfiguration(key, this.configuration);
        if (node == null || node.isNull()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!node.isArray()) {
            throw new IllegalArgumentException(String.format(UNSUPPORTED_TYPE_ERROR_MESSAGE, key, node.getNodeType()));
        }
        for (JsonNode elem : node) {
            String resolved;
            if (!elem.isValueNode()) {
                throw new IllegalArgumentException(String.format(UNSUPPORTED_TYPE_ERROR_MESSAGE, key, elem.getNodeType()));
            }
            String raw = elem.asText();
            if (raw == null || raw.trim().isEmpty() || (resolved = this.resolveConfigurationProperty(key, raw)).isEmpty()) continue;
            result.add(resolved);
        }
        return result;
    }

    private static JsonNode readFromConfiguration(String key, JsonNode configuration) {
        String[] path = key.split("\\.");
        JsonNode node = configuration;
        for (String pathPart : path) {
            if ((node = node.get(pathPart)) != null) continue;
            return null;
        }
        return node;
    }

    private Path getAbsolutePath(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        File absolutePathConversionFile = this.getSignalConfigurationResourceFromArtifactOrFromFileSystem(path);
        return absolutePathConversionFile.toPath().toAbsolutePath();
    }

    private void parseConfiguration(File configurationFile) throws IOException {
        this.configuration = configFileMapper.readTree(configurationFile);
    }
}

