/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.memory.bytebuffer;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.memory.provider.ByteBufferProvider;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ByteBufferProviderEventContext;
import org.mule.runtime.internal.memory.bytebuffer.profiling.ContainerProfilingScope;
import org.mule.runtime.internal.memory.bytebuffer.profiling.DefaultByteBufferProviderEventContext;

public class WeavePoolBasedByteBufferProvider
implements ByteBufferProvider<ByteBuffer> {
    private final int capacity;
    private final int maxSize;
    private final String name;
    private final WeaveByteBufferPool pool;
    ProfilingDataProducer<ByteBufferProviderEventContext, Object> allocationDataProducer;
    ProfilingDataProducer<ByteBufferProviderEventContext, Object> deallocationDataProducer;

    protected WeavePoolBasedByteBufferProvider(String name, int capacity, int maxSize, ProfilingService profilingService) {
        this.name = name;
        this.capacity = capacity;
        this.maxSize = maxSize;
        this.pool = new WeaveByteBufferPool();
        this.allocationDataProducer = profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.MEMORY_BYTE_BUFFER_ALLOCATION, (ProfilingProducerScope)new ContainerProfilingScope());
        this.deallocationDataProducer = profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.MEMORY_BYTE_BUFFER_DEALLOCATION, (ProfilingProducerScope)new ContainerProfilingScope());
    }

    public ByteBuffer allocate(int size) {
        this.allocationDataProducer.triggerProfilingEvent((ProfilingEventContext)new DefaultByteBufferProviderEventContext(this.name, System.currentTimeMillis(), this.capacity));
        ByteBuffer byteBuffer = this.pool.take();
        if (byteBuffer == null) {
            return ByteBuffer.allocate(this.capacity);
        }
        return byteBuffer;
    }

    public void release(ByteBuffer buffer) {
        this.deallocationDataProducer.triggerProfilingEvent((ProfilingEventContext)new DefaultByteBufferProviderEventContext(this.name, System.currentTimeMillis(), buffer.limit()));
        if (buffer.isDirect() && buffer.capacity() == this.capacity) {
            this.pool.release(buffer);
        }
    }

    public byte[] getByteArray(int size) {
        return new byte[size];
    }

    public ByteBuffer allocateAtLeast(int size) {
        return null;
    }

    public ByteBuffer reallocate(ByteBuffer oldBuffer, int newSize) {
        return null;
    }

    public void dispose() {
        this.pool.dispose();
    }

    WeaveByteBufferPool getPool() {
        return this.pool;
    }

    protected final class WeaveByteBufferPool {
        private final ConcurrentLinkedDeque<ByteBuffer> queue = new ConcurrentLinkedDeque();
        private final AtomicInteger amount = new AtomicInteger();

        protected WeaveByteBufferPool() {
        }

        private ByteBuffer take() {
            ByteBuffer buffer = this.queuePoll();
            if (buffer == null) {
                if (this.amount.incrementAndGet() <= WeavePoolBasedByteBufferProvider.this.maxSize) {
                    return ByteBuffer.allocateDirect(WeavePoolBasedByteBufferProvider.this.capacity);
                }
                this.amount.decrementAndGet();
                return null;
            }
            buffer.limit(WeavePoolBasedByteBufferProvider.this.capacity);
            return buffer;
        }

        private void release(ByteBuffer buffer) {
            this.queueOffer(buffer);
        }

        int size() {
            return this.queue.size();
        }

        private ByteBuffer queuePoll() {
            return this.queue.poll();
        }

        private void queueOffer(ByteBuffer buffer) {
            this.clear(buffer);
            this.queue.offerFirst(buffer);
        }

        private void clear(ByteBuffer buffer) {
            buffer.clear();
            buffer.limit(0);
        }

        Boolean isEmpty() {
            return this.queue.isEmpty();
        }

        private void dispose() {
            this.queue.clear();
        }
    }
}

