/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.mule.runtime.module.log4j.internal.MuleLoggerContextFactory;

class ApplicationReconfigurableLoggerContextSelector
implements ContextSelector {
    private final MuleLoggerContextFactory loggerContextFactory = new MuleLoggerContextFactory();
    private static final ClassLoader SYSTEM_CLASSLOADER = ClassLoader.getSystemClassLoader();
    private LoggerContext loggerContext = this.loggerContextFactory.build(SYSTEM_CLASSLOADER, this, false);

    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        return this.loggerContext;
    }

    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation) {
        return this.getContext(fqcn, loader, currentContext);
    }

    public List<LoggerContext> getLoggerContexts() {
        return Arrays.asList(this.loggerContext);
    }

    public void removeContext(LoggerContext context) {
        throw new UnsupportedOperationException("It is not allowed to remove contexts in a selector that depends on a single app.");
    }

    public void reconfigureAccordingToAppClassloader(ClassLoader classloader) {
        LoggerContext applicationClassLoaderLoggerContext = this.loggerContextFactory.build(classloader, this, true);
        applicationClassLoaderLoggerContext.reconfigure();
        this.loggerContext.updateLoggers(applicationClassLoaderLoggerContext.getConfiguration());
        this.loggerContext.reconfigure(applicationClassLoaderLoggerContext.getConfiguration());
        this.loggerContext.reconfigure();
        this.loggerContext = applicationClassLoaderLoggerContext;
    }
}

