/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.license.api;

public class PluginLicenseValidationRequest {
    private final String entitlement;
    private final String pluginVersion;
    private final String pluginProvider;
    private final String pluginName;
    private final boolean allowsEvaluation;
    private final ClassLoader artifactClassLoader;
    private final ClassLoader pluginClassLoader;

    private PluginLicenseValidationRequest(String entitlement, String pluginVersion, String pluginProvider, String pluginName, boolean allowsEvaluation, ClassLoader artifactClassLoader, ClassLoader pluginClassLoader) {
        this.entitlement = entitlement;
        this.pluginVersion = pluginVersion;
        this.pluginProvider = pluginProvider;
        this.pluginName = pluginName;
        this.allowsEvaluation = allowsEvaluation;
        this.artifactClassLoader = artifactClassLoader;
        this.pluginClassLoader = pluginClassLoader;
    }

    public String getEntitlement() {
        return this.entitlement;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public String getPluginProvider() {
        return this.pluginProvider;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public boolean isAllowsEvaluation() {
        return this.allowsEvaluation;
    }

    public ClassLoader getArtifactClassLoader() {
        return this.artifactClassLoader;
    }

    public ClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String pluginVersion;
        private String pluginName;
        private String pluginProvider;
        private String entitlement;
        private boolean allowsEvaluation;
        private ClassLoader artifactClassLoader;
        private ClassLoader pluginClassLoader;

        private Builder() {
        }

        public Builder withPluginVersion(String pluginVersion) {
            this.pluginVersion = pluginVersion;
            return this;
        }

        public Builder withPluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public Builder withPluginProvider(String pluginProvider) {
            this.pluginProvider = pluginProvider;
            return this;
        }

        public Builder withEntitlement(String entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        public Builder withAllowsEvaluation(boolean allowsEvaluation) {
            this.allowsEvaluation = allowsEvaluation;
            return this;
        }

        public Builder withArtifactClassLoader(ClassLoader classLoader) {
            this.artifactClassLoader = classLoader;
            return this;
        }

        public Builder withPluginClassLoader(ClassLoader classLoader) {
            this.pluginClassLoader = classLoader;
            return this;
        }

        public PluginLicenseValidationRequest build() {
            return new PluginLicenseValidationRequest(this.entitlement, this.pluginVersion, this.pluginProvider, this.pluginName, this.allowsEvaluation, this.artifactClassLoader, this.pluginClassLoader);
        }
    }
}

