/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.MessageFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.launcher.log4j2.DispatchingLogger;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DispatchingLoggerTestCase
extends AbstractMuleTestCase {
    private static final String LOGGER_NAME = DispatchingLoggerTestCase.class.getName();
    private static final String MESSAGE = "Hello Log!";
    private ClassLoader currentClassLoader;
    @Mock
    private ClassLoader additionalClassLoader;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Logger originalLogger;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private LoggerContext loggerContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ContextSelector contextSelector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageFactory messageFactory;
    private Logger logger;

    @Before
    public void before() {
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
        Mockito.when((Object)this.loggerContext.getConfiguration().getLoggerConfig(Matchers.anyString()).getLevel()).thenReturn((Object)Level.INFO);
        this.logger = new DispatchingLogger(this.originalLogger, this.currentClassLoader.hashCode(), this.loggerContext, this.contextSelector, this.messageFactory){

            public String getName() {
                return LOGGER_NAME;
            }
        };
    }

    @Test
    public void currentClassLoader() {
        this.logger.info(MESSAGE);
        ((Logger)Mockito.verify((Object)this.originalLogger)).info(MESSAGE);
    }

    @Test
    public void anotherClassLoader() {
        ClassUtils.withContextClassLoader((ClassLoader)this.additionalClassLoader, () -> {
            this.logger.info(MESSAGE);
            ((Logger)Mockito.verify((Object)this.originalLogger)).info(MESSAGE);
        });
    }

    @Test
    public void regionClassLoader() {
        RegionClassLoader regionClassLoader = (RegionClassLoader)Mockito.mock(RegionClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)regionClassLoader, () -> {
            this.logger.info(MESSAGE);
            ((ContextSelector)Mockito.verify((Object)this.contextSelector)).getContext(LOGGER_NAME, (ClassLoader)regionClassLoader, true);
        });
    }
}

