/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.config.StartupContext;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.classloader.net.MuleArtifactUrlStreamHandler;
import org.mule.runtime.module.artifact.classloader.net.MuleUrlStreamHandlerFactory;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.impl.internal.MuleArtifactResourcesRegistry;
import org.mule.runtime.module.deployment.internal.MuleDeploymentService;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderManager;
import org.mule.runtime.module.launcher.MuleContainerStartupSplashScreen;
import org.mule.runtime.module.launcher.coreextension.ClasspathMuleCoreExtensionDiscoverer;
import org.mule.runtime.module.launcher.coreextension.DefaultMuleCoreExtensionManagerServer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionManagerServer;
import org.mule.runtime.module.launcher.coreextension.ReflectionMuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.log4j2.MuleLog4jContextFactory;
import org.mule.runtime.module.reboot.MuleContainerBootstrap;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.internal.RepositoryServiceFactory;
import org.mule.runtime.module.service.ServiceManager;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.runtime.module.tooling.internal.DefaultToolingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleContainer {
    public static final String[][] CLI_OPTIONS = new String[][]{{"builder", "true", "Configuration Builder Type"}, {"config", "true", "Configuration File"}, {"idle", "false", "Whether to run in idle (unconfigured) mode"}, {"main", "true", "Main Class"}, {"mode", "true", "Run Mode"}, {"props", "true", "Startup Properties"}, {"production", "false", "Production Mode"}, {"debug", "false", "Configure Mule for JPDA remote debugging."}, {"app", "true", "Application to start"}};
    private static final Logger logger;
    private static String startupPropertiesFile;
    private static MuleShutdownHook muleShutdownHook;
    protected final DeploymentService deploymentService;
    private final RepositoryService repositoryService;
    private final ToolingService toolingService;
    private final MuleCoreExtensionManagerServer coreExtensionManager;
    private MuleArtifactResourcesRegistry artifactResourcesRegistry = new MuleArtifactResourcesRegistry.Builder().build();
    private static MuleLog4jContextFactory log4jContextFactory;
    private ServiceManager serviceManager;
    private ExtensionModelLoaderManager extensionModelLoaderManager;

    public static void main(String[] args) throws Exception {
        MuleContainer container = new MuleContainer(args);
        container.start(true);
    }

    public MuleContainer(String[] args) {
        this.init(args);
        this.serviceManager = this.artifactResourcesRegistry.getServiceManager();
        this.extensionModelLoaderManager = this.artifactResourcesRegistry.getExtensionModelLoaderManager();
        this.deploymentService = new MuleDeploymentService(this.artifactResourcesRegistry.getDomainFactory(), this.artifactResourcesRegistry.getApplicationFactory(), () -> MuleDeploymentService.findSchedulerService((ServiceManager)this.serviceManager));
        this.repositoryService = new RepositoryServiceFactory().createRepositoryService();
        this.toolingService = new DefaultToolingService(this.artifactResourcesRegistry.getApplicationFactory());
        this.coreExtensionManager = new DefaultMuleCoreExtensionManagerServer(new ClasspathMuleCoreExtensionDiscoverer(this.artifactResourcesRegistry.getContainerClassLoader()), new ReflectionMuleCoreExtensionDependencyResolver());
        this.artifactResourcesRegistry.getContainerClassLoader().dispose();
    }

    public MuleContainer(DeploymentService deploymentService, RepositoryService repositoryService, ToolingService toolingService, MuleCoreExtensionManagerServer coreExtensionManager, ServiceManager serviceManager, ExtensionModelLoaderManager extensionModelLoaderManager) {
        this(new String[0], deploymentService, repositoryService, toolingService, coreExtensionManager, serviceManager, extensionModelLoaderManager);
    }

    public MuleContainer(String[] args, DeploymentService deploymentService, RepositoryService repositoryService, ToolingService toolingService, MuleCoreExtensionManagerServer coreExtensionManager, ServiceManager serviceManager, ExtensionModelLoaderManager extensionModelLoaderManager) throws IllegalArgumentException {
        this.init(args);
        this.deploymentService = deploymentService;
        this.coreExtensionManager = coreExtensionManager;
        this.repositoryService = repositoryService;
        this.serviceManager = serviceManager;
        this.extensionModelLoaderManager = extensionModelLoaderManager;
        this.toolingService = toolingService;
    }

    protected void init(String[] args) throws IllegalArgumentException {
        Map commandlineOptions;
        try {
            commandlineOptions = SystemUtils.getCommandLineOptions((String[])args, (String[][])CLI_OPTIONS);
        }
        catch (DefaultMuleException me) {
            throw new IllegalArgumentException(me.toString());
        }
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
        MuleArtifactUrlStreamHandler.register();
        String propertiesFile = (String)commandlineOptions.get("props");
        if (propertiesFile != null) {
            MuleContainer.setStartupPropertiesFile(propertiesFile);
        }
        StartupContext.get().setStartupOptions(commandlineOptions);
    }

    private void createExecutionMuleFolder() {
        File executionFolder = MuleFoldersUtil.getExecutionFolder();
        if (!executionFolder.exists() && !executionFolder.mkdirs()) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("Could not create folder %s, validate that the process has permissions over that directory", executionFolder.getAbsolutePath())));
        }
    }

    public void start(boolean registerShutdownHook) throws MuleException {
        if (registerShutdownHook) {
            this.registerShutdownHook();
        }
        this.showSplashScreen();
        try {
            this.createExecutionMuleFolder();
            this.coreExtensionManager.setDeploymentService(this.deploymentService);
            this.coreExtensionManager.setRepositoryService(this.repositoryService);
            this.coreExtensionManager.setArtifactClassLoaderManager((ArtifactClassLoaderManager)this.artifactResourcesRegistry.getArtifactClassLoaderManager());
            this.coreExtensionManager.setToolingService(this.toolingService);
            this.coreExtensionManager.initialise();
            this.coreExtensionManager.start();
            this.serviceManager.start();
            this.extensionModelLoaderManager.start();
            this.deploymentService.start();
        }
        catch (Throwable e) {
            this.shutdown(e);
        }
    }

    protected void showSplashScreen() {
        MuleContainerStartupSplashScreen splashScreen = new MuleContainerStartupSplashScreen();
        splashScreen.doBody();
        logger.info(splashScreen.toString());
    }

    public void shutdown(Throwable e) throws MuleException {
        I18nMessage msg = CoreMessages.fatalErrorWhileRunning();
        MuleException muleException = ExceptionHelper.getRootMuleException((Throwable)e);
        if (muleException != null) {
            logger.error(muleException.getDetailedMessage());
        } else {
            logger.error(msg.toString() + " " + e.getMessage(), e);
        }
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add(msg.getMessage());
        Throwable root = ExceptionHelper.getRootException((Throwable)e);
        msgs.add(root.getMessage() + " (" + root.getClass().getName() + ")");
        msgs.add(" ");
        msgs.add(CoreMessages.fatalErrorInShutdown().getMessage());
        String shutdownMessage = StringMessageUtils.getBoilerPlate(msgs, (char)'*', (int)80);
        logger.error(shutdownMessage);
        this.doShutdown();
    }

    public void shutdown() throws MuleException {
        logger.info("Mule container shutting down due to normal shutdown request");
        this.doShutdown();
    }

    protected void doShutdown() throws MuleException {
        this.unregisterShutdownHook();
        this.stop();
        System.exit(0);
    }

    public void stop() throws MuleException {
        MuleContainerBootstrap.dispose();
        this.coreExtensionManager.stop();
        if (this.deploymentService != null) {
            this.deploymentService.stop();
        }
        if (this.serviceManager != null) {
            this.serviceManager.stop();
        }
        if (this.extensionModelLoaderManager != null) {
            this.extensionModelLoaderManager.stop();
        }
        this.coreExtensionManager.dispose();
        if (LogManager.getFactory() instanceof MuleLog4jContextFactory) {
            ((MuleLog4jContextFactory)LogManager.getFactory()).dispose();
        }
        if (log4jContextFactory != null) {
            log4jContextFactory.dispose();
        }
    }

    public Logger getLogger() {
        return logger;
    }

    public void registerShutdownHook() {
        if (muleShutdownHook == null) {
            muleShutdownHook = new MuleShutdownHook();
        } else {
            Runtime.getRuntime().removeShutdownHook(muleShutdownHook);
        }
        Runtime.getRuntime().addShutdownHook(muleShutdownHook);
    }

    public void unregisterShutdownHook() {
        if (muleShutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(muleShutdownHook);
        }
    }

    public static String getStartupPropertiesFile() {
        return startupPropertiesFile;
    }

    public static void setStartupPropertiesFile(String startupPropertiesFile) {
        MuleContainer.startupPropertiesFile = startupPropertiesFile;
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public ArtifactClassLoader getContainerClassLoader() {
        return this.artifactResourcesRegistry.getContainerClassLoader();
    }

    static {
        startupPropertiesFile = null;
        if (System.getProperty("mule.simpleLog") == null) {
            System.setProperty("log4j2.loggerContextFactory", MuleLog4jContextFactory.class.getName());
            log4jContextFactory = new MuleLog4jContextFactory();
            LogManager.setFactory((LoggerContextFactory)log4jContextFactory);
        }
        logger = LoggerFactory.getLogger(MuleContainer.class);
    }

    private class MuleShutdownHook
    extends Thread {
        public MuleShutdownHook() {
            super("Mule.shutdown.hook");
        }

        @Override
        public void run() {
            try {
                MuleContainer.this.stop();
            }
            catch (MuleException e) {
                logger.warn("Error stopping mule container", (Throwable)e);
            }
        }
    }
}

