/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.container.api.CoreExtensionsAware;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;
import org.mule.runtime.module.launcher.coreextension.DefaultMuleCoreExtensionManagerServer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDiscoverer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionManagerServer;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.api.RepositoryServiceAware;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultMuleCoreExtensionManagerTestCase
extends AbstractMuleTestCase {
    private final MuleCoreExtensionDiscoverer coreExtensionDiscoverer = (MuleCoreExtensionDiscoverer)Mockito.mock(MuleCoreExtensionDiscoverer.class);
    private final MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver = (MuleCoreExtensionDependencyResolver)Mockito.mock(MuleCoreExtensionDependencyResolver.class);
    private MuleCoreExtensionManagerServer coreExtensionManager = new DefaultMuleCoreExtensionManagerServer(this.coreExtensionDiscoverer, this.coreExtensionDependencyResolver);

    @Test
    public void discoversMuleCoreExtension() throws Exception {
        this.coreExtensionManager.initialise();
        ((MuleCoreExtensionDiscoverer)Mockito.verify((Object)this.coreExtensionDiscoverer)).discover();
    }

    @Test
    public void injectsDeploymentServiceAwareCoreExtension() throws Exception {
        Consumer<DeploymentService> setServiceFunction = service -> this.coreExtensionManager.setDeploymentService(service);
        BiConsumer<List, DeploymentService> verificationFunction = (extensions, service) -> ((TestDeploymentServiceAwareExtension)Mockito.verify(extensions.get(0))).setDeploymentService((DeploymentService)service);
        this.testServiceInjection(DeploymentService.class, TestDeploymentServiceAwareExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectRepositoryServiceAwareCoreExtension() throws Exception {
        Consumer<RepositoryService> setServiceFunction = service -> this.coreExtensionManager.setRepositoryService(service);
        BiConsumer<List, RepositoryService> verificationFunction = (extensions, service) -> ((TestRepositoryServiceAwareExtension)Mockito.verify(extensions.get(0))).setRepositoryService((RepositoryService)service);
        this.testServiceInjection(RepositoryService.class, TestRepositoryServiceAwareExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void initializesDeploymentListenerCoreExtension() throws Exception {
        Consumer<DeploymentService> setServiceFunction = service -> this.coreExtensionManager.setDeploymentService(service);
        BiConsumer<List, DeploymentService> verificationFunction = (extensions, service) -> ((DeploymentService)Mockito.verify((Object)service)).addDeploymentListener((DeploymentListener)extensions.get(0));
        this.testServiceInjection(DeploymentService.class, TestDeploymentListenerExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectsCoreExtensionsAwareCoreExtension() throws Exception {
        Consumer<DeploymentService> setServiceFunction = service -> {};
        BiConsumer<List, DeploymentService> verificationFunction = (extensions, service) -> ((TestCoreExtensionsAwareExtension)Mockito.verify(extensions.get(0))).setCoreExtensions(new ArrayList(extensions));
        this.testServiceInjection(DeploymentService.class, TestCoreExtensionsAwareExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void startsCoreExtensionsInOrder() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension1 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        MuleCoreExtension extension2 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        extensions.add(extension1);
        extensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        LinkedList<MuleCoreExtension> orderedExtensions = new LinkedList<MuleCoreExtension>();
        orderedExtensions.add(extension2);
        orderedExtensions.add(extension1);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(orderedExtensions);
        this.coreExtensionManager.initialise();
        this.coreExtensionManager.start();
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{extension1, extension2});
        ((MuleCoreExtension)ordered.verify((Object)extension2)).start();
        ((MuleCoreExtension)ordered.verify((Object)extension1)).start();
    }

    @Test
    public void stopsCoreExtensionsInOrder() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension1 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        MuleCoreExtension extension2 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        extensions.add(extension1);
        extensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        LinkedList<MuleCoreExtension> orderedExtensions = new LinkedList<MuleCoreExtension>();
        orderedExtensions.add(extension1);
        orderedExtensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(orderedExtensions);
        this.coreExtensionManager.initialise();
        this.coreExtensionManager.stop();
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{extension1, extension2});
        ((MuleCoreExtension)ordered.verify((Object)extension2)).stop();
        ((MuleCoreExtension)ordered.verify((Object)extension1)).stop();
    }

    @Test
    public void initializesCoreExtensionsInOrder() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension1 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        MuleCoreExtension extension2 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        extensions.add(extension1);
        extensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        LinkedList<MuleCoreExtension> orderedExtensions = new LinkedList<MuleCoreExtension>();
        orderedExtensions.add(extension2);
        orderedExtensions.add(extension1);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(orderedExtensions);
        this.coreExtensionManager.initialise();
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{extension1, extension2});
        ((MuleCoreExtension)ordered.verify((Object)extension2)).initialise();
        ((MuleCoreExtension)ordered.verify((Object)extension1)).initialise();
    }

    @Test
    public void disposesCoreExtensions() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        TestDeploymentServiceAwareExtension extension1 = (TestDeploymentServiceAwareExtension)Mockito.mock(TestDeploymentServiceAwareExtension.class);
        MuleCoreExtension extension2 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        extensions.add(extension1);
        extensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        LinkedList<MuleCoreExtension> orderedExtensions = new LinkedList<MuleCoreExtension>();
        orderedExtensions.add(extension1);
        orderedExtensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(orderedExtensions);
        this.coreExtensionManager.initialise();
        this.coreExtensionManager.dispose();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{extension1, extension2});
        ((TestDeploymentServiceAwareExtension)inOrder.verify((Object)extension1)).dispose();
        ((MuleCoreExtension)inOrder.verify((Object)extension2)).dispose();
    }

    @Test
    public void resolvesCoreExtensionDependencies() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        extensions.add(extension);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        this.coreExtensionManager.initialise();
        ((MuleCoreExtensionDependencyResolver)Mockito.verify((Object)this.coreExtensionDependencyResolver)).resolveDependencies(extensions);
    }

    private <ServiceType, CoreExtensionType extends MuleCoreExtension> void testServiceInjection(Class<ServiceType> serviceType, Class<CoreExtensionType> coreExtensionType, Consumer<ServiceType> setServiceFunction, BiConsumer<List<CoreExtensionType>, ServiceType> verificationFunction) throws DefaultMuleException, InitialisationException {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension = (MuleCoreExtension)Mockito.mock(coreExtensionType);
        extensions.add(extension);
        Object service = Mockito.mock(serviceType);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(extensions);
        setServiceFunction.accept(service);
        this.coreExtensionManager.initialise();
        verificationFunction.accept(extensions, service);
    }

    public static interface TestCoreExtensionsAwareExtension
    extends MuleCoreExtension,
    CoreExtensionsAware {
    }

    public static interface TestDeploymentListenerExtension
    extends MuleCoreExtension,
    DeploymentListener {
    }

    public static interface TestRepositoryServiceAwareExtension
    extends MuleCoreExtension,
    RepositoryServiceAware {
    }

    public static interface TestDeploymentServiceAwareExtension
    extends MuleCoreExtension,
    DeploymentServiceAware {
    }
}

