/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import java.util.function.Consumer;
import org.mule.runtime.http.api.client.proxy.DelegatingProxyConfigurer;
import org.mule.runtime.http.api.client.proxy.NtlmProxyConfigBuilder;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.client.proxy.ProxyConfigBuilder;
import org.mule.sdk.api.http.client.auth.HttpAuthenticationConfigurer;
import org.mule.sdk.api.http.client.proxy.ProxyConfigurer;

public class ProxyConfigImpl
implements ProxyConfigurer,
HttpAuthenticationConfigurer,
DelegatingProxyConfigurer {
    private String host;
    private int port;
    private String username;
    private String password;
    private String nonProxyHosts;
    private String ntlmDomain;
    private boolean isNtlm = false;
    private Object delegatedProxyConfig;

    public ProxyConfigurer host(String host) {
        this.host = host;
        return this;
    }

    public ProxyConfigurer port(int port) {
        this.port = port;
        return this;
    }

    public ProxyConfigurer nonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
        return this;
    }

    public ProxyConfigurer auth(Consumer<HttpAuthenticationConfigurer> authConfigurer) {
        authConfigurer.accept(this);
        return this;
    }

    public void basic(String username, String password, boolean preemptive) {
        if (preemptive) {
            throw new IllegalArgumentException("Preemptive basic authentication is not supported for proxy");
        }
        this.username = username;
        this.password = password;
    }

    public void digest(String username, String password, boolean preemptive) {
        throw new IllegalArgumentException("Digest authentication is not supported for proxy");
    }

    public void ntlm(String username, String password, boolean preemptive, String domain, String workstation) {
        if (preemptive) {
            throw new IllegalArgumentException("Preemptive NTLM authentication is not supported for proxy");
        }
        if (workstation != null) {
            throw new IllegalArgumentException("NTLM workstation can't be configured for proxy");
        }
        this.username = username;
        this.password = password;
        this.ntlmDomain = domain;
        this.isNtlm = true;
    }

    public DelegatingProxyConfigurer delegateConfig(ProxyConfig proxyConfig) {
        this.delegatedProxyConfig = proxyConfig;
        return this;
    }

    public ProxyConfig build() {
        Object object = this.delegatedProxyConfig;
        if (object instanceof ProxyConfig) {
            ProxyConfig config = (ProxyConfig)object;
            return config;
        }
        if (this.isNtlm) {
            return ((NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)ProxyConfig.NtlmProxyConfig.builder().host(this.host)).port(this.port)).username(this.username)).password(this.password)).nonProxyHosts(this.nonProxyHosts)).ntlmDomain(this.ntlmDomain).build();
        }
        return ((ProxyConfigBuilder)((ProxyConfigBuilder)((ProxyConfigBuilder)((ProxyConfigBuilder)((ProxyConfigBuilder)ProxyConfig.builder().host(this.host)).port(this.port)).username(this.username)).password(this.password)).nonProxyHosts(this.nonProxyHosts)).build();
    }
}

