/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.globalconfig.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigSyntax;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.StampedLock;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.globalconfig.api.exception.RuntimeGlobalConfigException;
import org.mule.runtime.globalconfig.internal.MavenConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalConfigLoader {
    private static final String CONFIG_ROOT_ELEMENT_NAME = "muleRuntimeConfig";
    private static Logger LOGGER = LoggerFactory.getLogger(GlobalConfigLoader.class);
    private static MavenConfiguration mavenConfig;
    private static StampedLock lock;
    private static final String MULE_SCHEMA_JSON_LOCATION = "mule-schema.json";

    private static void initialiseGlobalConfig() {
        Config muleRuntimeConfig;
        Config config = ConfigFactory.load((ClassLoader)GlobalConfigLoader.class.getClassLoader(), (String)"mule-config", (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.JSON), (ConfigResolveOptions)ConfigResolveOptions.defaults());
        Config config2 = muleRuntimeConfig = config.hasPath(CONFIG_ROOT_ELEMENT_NAME) ? config.getConfig(CONFIG_ROOT_ELEMENT_NAME) : null;
        if (muleRuntimeConfig == null) {
            mavenConfig = MavenConfigBuilder.buildNullMavenConfig();
        } else {
            String effectiveConfigAsJson = muleRuntimeConfig.root().render(ConfigRenderOptions.concise().setJson(true).setComments(false));
            String prettyPrintConfig = muleRuntimeConfig.root().render(ConfigRenderOptions.defaults().setComments(true).setJson(true).setFormatted(true));
            try (InputStream schemaStream = GlobalConfigLoader.class.getClassLoader().getResourceAsStream(MULE_SCHEMA_JSON_LOCATION);){
                JSONObject rawSchema = new JSONObject(new JSONTokener(schemaStream));
                Schema schema = SchemaLoader.load((JSONObject)rawSchema);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using effective mule-config.json configuration: \n" + prettyPrintConfig);
                }
                schema.validate((Object)new JSONObject(effectiveConfigAsJson));
                Config mavenConfig = muleRuntimeConfig.getConfig("maven");
                GlobalConfigLoader.mavenConfig = mavenConfig != null ? MavenConfigBuilder.buildMavenConfig(mavenConfig) : MavenConfigBuilder.buildNullMavenConfig();
            }
            catch (ValidationException e) {
                LOGGER.info("Mule global config exception. Effective configuration is (config is a merge of MULE_HOME/conf/mule-config.json and system properties): \n " + prettyPrintConfig);
                throw new RuntimeGlobalConfigException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new RuntimeGlobalConfigException(I18nMessageFactory.createStaticMessage((String)String.format("resources %s missing from the runtime classpath", MULE_SCHEMA_JSON_LOCATION)), e);
            }
        }
    }

    public static void reset() {
        long stamp = lock.writeLock();
        try {
            mavenConfig = null;
            ConfigFactory.invalidateCaches();
            GlobalConfigLoader.initialiseGlobalConfig();
        }
        finally {
            lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MavenConfiguration getMavenConfig() {
        long stamp = lock.readLock();
        try {
            if (mavenConfig == null) {
                long writeStamp = lock.tryConvertToWriteLock(stamp);
                if (writeStamp == 0L) {
                    lock.unlockRead(stamp);
                    stamp = lock.writeLock();
                } else {
                    stamp = writeStamp;
                }
                if (mavenConfig == null) {
                    GlobalConfigLoader.initialiseGlobalConfig();
                }
            }
            MavenConfiguration mavenConfiguration = mavenConfig;
            return mavenConfiguration;
        }
        finally {
            lock.unlock(stamp);
        }
    }

    static {
        lock = new StampedLock();
    }
}

