/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.xml;

import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.loader.util.InfrastructureTypeMapping;

public class TlsEnabledComponentUtils {
    public static final QName MODULE_TLS_ENABLED_MARKER_ANNOTATION_QNAME = new QName("http://www.w3.org/2000/xmlns/", "tlsEnabled", "xmlns");

    public static boolean isTlsContextFactoryParameter(ComponentParameterAst parameter) {
        return TlsEnabledComponentUtils.isTlsContextFactoryParameter(parameter.getModel());
    }

    public static boolean isTlsConfigurationSupported(ComponentAst componentAst) {
        return componentAst.getModel(ParameterizedModel.class).map(TlsEnabledComponentUtils::hasTlsContextFactoryParameter).orElse(false);
    }

    public static boolean isTlsEnabled(ComponentAst componentAst) {
        Object annotation = componentAst.getAnnotations().get(MODULE_TLS_ENABLED_MARKER_ANNOTATION_QNAME.toString());
        if (annotation == null) {
            return false;
        }
        return Boolean.parseBoolean(annotation.toString());
    }

    public static void addTlsContextParameter(ParameterGroupDeclarer<?> parameterGroupDeclarer, ComponentAst targetComponent) {
        InfrastructureTypeMapping.InfrastructureType tlsContextInfrastructureType = (InfrastructureTypeMapping.InfrastructureType)InfrastructureTypeMapping.getMap().get(TlsContextFactory.class);
        MetadataType tlsContextType = new DefaultExtensionsTypeLoaderFactory().createTypeLoader(TlsEnabledComponentUtils.class.getClassLoader()).load(TlsContextFactory.class);
        Object parameterDeclarer = TlsEnabledComponentUtils.requiresTlsContextFactoryParameter(targetComponent) && !TlsEnabledComponentUtils.isTlsContextFactoryProvided(targetComponent) ? parameterGroupDeclarer.withRequiredParameter(tlsContextInfrastructureType.getName()) : parameterGroupDeclarer.withOptionalParameter(tlsContextInfrastructureType.getName());
        parameterDeclarer = parameterDeclarer.ofType(tlsContextType).withRole(ParameterRole.BEHAVIOUR).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withModelProperty((ModelProperty)new SyntheticModelModelProperty()).withModelProperty((ModelProperty)new InfrastructureParameterModelProperty(tlsContextInfrastructureType.getSequence()));
        InfrastructureTypeMapping.getQName((String)tlsContextInfrastructureType.getName()).ifPresent(arg_0 -> ((ParameterDeclarer)parameterDeclarer).withModelProperty(arg_0));
        InfrastructureTypeMapping.getDslConfiguration((String)tlsContextInfrastructureType.getName()).ifPresent(arg_0 -> ((ParameterDeclarer)parameterDeclarer).withDsl(arg_0));
    }

    private static boolean isTlsContextFactoryParameter(ParameterModel parameterModel) {
        return ExtensionMetadataTypeUtils.getType((MetadataType)parameterModel.getType()).map(TlsContextFactory.class::isAssignableFrom).orElse(false);
    }

    private static boolean hasTlsContextFactoryParameter(ParameterizedModel model) {
        return model.getAllParameterModels().stream().anyMatch(TlsEnabledComponentUtils::isTlsContextFactoryParameter);
    }

    private static boolean requiresTlsContextFactoryParameter(ParameterizedModel model) {
        return model.getAllParameterModels().stream().filter(ParameterModel::isRequired).anyMatch(TlsEnabledComponentUtils::isTlsContextFactoryParameter);
    }

    private static boolean requiresTlsContextFactoryParameter(ComponentAst componentAst) {
        return componentAst.getModel(ParameterizedModel.class).map(TlsEnabledComponentUtils::requiresTlsContextFactoryParameter).orElse(false);
    }

    private static boolean isTlsContextFactoryProvided(ComponentAst componentAst) {
        return componentAst.getParameters().stream().filter(TlsEnabledComponentUtils::isTlsContextFactoryParameter).anyMatch(TlsEnabledComponentUtils::hasValue);
    }

    private static boolean hasValue(ComponentParameterAst parameterAst) {
        Either value = parameterAst.getValue();
        return value.isLeft() || value.isRight();
    }

    private TlsEnabledComponentUtils() {
    }
}

