/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.factories;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.extension.api.runtime.connectivity.ConnectionProviderFactory;
import org.mule.runtime.extension.internal.factories.XmlSdkConfigurationFactory;
import org.mule.runtime.extension.internal.factories.XmlSdkConnectionProviderBeanClassSupplier;
import org.mule.runtime.extension.internal.factories.XmlSdkConnectionProviderWrapper;

public class XmlSdkConnectionProviderFactory
implements ConnectionProviderFactory {
    private static final Pattern VARS_EXPRESSION_PATTERN = Pattern.compile("^#\\[vars\\.(\\w+)\\]$");
    private static final Function<ComponentParameterAst, Optional<String>> PROPERTY_USAGE = p -> p.getRawValue() != null ? Optional.of(VARS_EXPRESSION_PATTERN.matcher(p.getRawValue())).filter(Matcher::matches).map(matcher -> matcher.group(1)) : Optional.empty();
    private final ComponentAst innerConnectionProviderComponent;
    private final XmlSdkConfigurationFactory configurationFactory;
    private final Supplier<Class<? extends XmlSdkConnectionProviderWrapper<?>>> connectionWrapperClass;

    public XmlSdkConnectionProviderFactory(ComponentAst innerConnectionProviderComponent, List<ParameterDeclaration> configParamDeclarations, List<ParameterDeclaration> connProviderParamDeclarations, XmlSdkConfigurationFactory configurationFactory) {
        this.innerConnectionProviderComponent = Objects.requireNonNull(innerConnectionProviderComponent);
        this.configurationFactory = configurationFactory;
        this.connectionWrapperClass = new LazyValue(() -> new XmlSdkConnectionProviderBeanClassSupplier(this.resolveConnectionProviderProperties(innerConnectionProviderComponent, configParamDeclarations, connProviderParamDeclarations)).get());
    }

    private Set<ParameterDeclaration> resolveConnectionProviderProperties(ComponentAst innerConnectionProviderComponent, List<ParameterDeclaration> configParamDeclarations, List<ParameterDeclaration> connProviderParamDeclarations) {
        HashSet<ParameterDeclaration> params = new HashSet<ParameterDeclaration>();
        Set connectionProviderProperties = innerConnectionProviderComponent.recursiveStream().flatMap(c -> c.getParameters().stream()).map(PROPERTY_USAGE).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        configParamDeclarations.stream().filter(configParamDecl -> connectionProviderProperties.contains(configParamDecl.getName())).forEach(params::add);
        params.addAll(connProviderParamDeclarations);
        return params;
    }

    public ConnectionProvider newInstance() {
        try {
            XmlSdkConnectionProviderWrapper<?> connectionProviderWrapper = this.connectionWrapperClass.get().getDeclaredConstructor(ComponentAst.class, Function.class).newInstance(this.innerConnectionProviderComponent, PROPERTY_USAGE);
            Object lastConfig = this.configurationFactory.getLastBuilt();
            BeanUtils.copyProperties(connectionProviderWrapper, (Object)lastConfig);
            return connectionProviderWrapper;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public Class getObjectType() {
        return this.connectionWrapperClass.get();
    }
}

