/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorResetHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CursorResetHandler.class);
    private final List<Pair<Cursor, Long>> cursorPositions;

    public CursorResetHandler(List<Cursor> cursors) {
        this.cursorPositions = this.getCursorPositions(cursors);
    }

    private List<Pair<Cursor, Long>> getCursorPositions(List<Cursor> cursors) {
        ArrayList<Pair<Cursor, Long>> cursorPositions = new ArrayList<Pair<Cursor, Long>>(cursors.size());
        for (Cursor cursor : cursors) {
            cursorPositions.add((Pair<Cursor, Long>)new Pair((Object)cursor, (Object)cursor.getPosition()));
        }
        return cursorPositions;
    }

    public void resetCursors() {
        this.cursorPositions.forEach(pair -> {
            block2: {
                try {
                    ((Cursor)pair.getFirst()).seek(((Long)pair.getSecond()).longValue());
                }
                catch (IOException e) {
                    if (!LOGGER.isWarnEnabled()) break block2;
                    LOGGER.warn("Could not reset cursor back to position " + String.valueOf(pair.getSecond()) + ". Inconsistencies might occur if a retry is attempted", (Throwable)e);
                }
            }
        });
    }
}

