/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;

public class PagedOperationModelValidator
implements ExtensionModelValidator {
    public void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            protected void onOperation(OperationModel operationModel) {
                boolean hasConnectionParameter = operationModel.getModelProperty(ExtensionOperationDescriptorModelProperty.class).map(property -> JavaExtensionModelParserUtils.getConnectionParameter(property.getOperationElement()).isPresent()).orElse(false);
                if (hasConnectionParameter && ComponentDeclarationUtils.isPagedOperation((ComponentModel)operationModel)) {
                    problemsReporter.addError(new Problem((NamedObject)operationModel, String.format("Operation '%s' in Extension '%s' is paged and has a parameter annotated with '%s' at the same time. Paged operation shouldn't have a connection parameter.", operationModel.getName(), extensionModel.getName(), Connection.class.getName())));
                }
            }
        }.walk(extensionModel);
    }
}

