/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.internal.message.EventInternalContext;
import org.mule.runtime.core.internal.policy.DefaultPolicyManager;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.context.Context;

public class SdkInternalContext
implements EventInternalContext<SdkInternalContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SdkInternalContext.class);
    private final Map<Pair<ComponentLocation, String>, LocationSpecificSdkInternalContext> locationSpecificContext = new ConcurrentHashMap<Pair<ComponentLocation, String>, LocationSpecificSdkInternalContext>(5);
    private UnaryOperator<Context> innerChainSubscriberContextMapping = UnaryOperator.identity();

    public static SdkInternalContext from(CoreEvent event) {
        return (SdkInternalContext)((InternalEvent)event).getSdkInternalContext();
    }

    public void removeContext(ComponentLocation location, String eventId) {
        LOGGER.debug("Removing context at location - {} for event - {}", (Object)this.getLocationString(location), (Object)eventId);
        this.locationSpecificContext.remove(new Pair((Object)location, (Object)eventId));
    }

    public void putContext(ComponentLocation location, String eventId) {
        String locationString = this.getLocationString(location);
        LOGGER.debug("Adding new context at location - {} for event - {}", (Object)locationString, (Object)eventId);
        LocationSpecificSdkInternalContext previousValue = this.locationSpecificContext.putIfAbsent((Pair<ComponentLocation, String>)new Pair((Object)location, (Object)eventId), new LocationSpecificSdkInternalContext());
        if (previousValue != null) {
            throw new IllegalStateException("Context at location - %s for event - %s already present".formatted(locationString, eventId));
        }
    }

    public void setConfiguration(ComponentLocation location, String eventId, Optional<ConfigurationInstance> configuration) {
        LOGGER.debug("Adding configuration at location - {} for event - {}", (Object)this.getLocationString(location), (Object)eventId);
        this.locationSpecificContext.get(new Pair((Object)location, (Object)eventId)).setConfiguration(configuration);
    }

    public Optional<ConfigurationInstance> getConfiguration(ComponentLocation location, String eventId) {
        return this.locationSpecificContext.get(new Pair((Object)location, (Object)eventId)).getConfiguration();
    }

    public <M extends ComponentModel> void setOperationExecutionParams(ComponentLocation location, String eventId, Optional<ConfigurationInstance> configuration, Map<String, Object> parameters, CoreEvent operationEvent, CompletableComponentExecutor.ExecutorCallback callback, ExecutionContextAdapter<M> executionContextAdapter) {
        String locationString = this.getLocationString(location);
        LOGGER.debug("Setting Operation Parameters at location - {} for event - {}", (Object)locationString, (Object)eventId);
        LocationSpecificSdkInternalContext<M> locationSpecificSdkInternalContext = this.getLocationSpecificSdkInternalContext(location, eventId);
        if (locationSpecificSdkInternalContext.getOperationExecutionParams() != null) {
            throw new IllegalStateException("Context at location - %s for event - %s already has Operation Parameters set".formatted(locationString, eventId));
        }
        locationSpecificSdkInternalContext.setOperationExecutionParams(configuration, parameters, operationEvent, callback, executionContextAdapter);
    }

    public <M extends ComponentModel> OperationExecutionParams<M> getOperationExecutionParams(ComponentLocation location, String eventId) {
        return this.getLocationSpecificSdkInternalContext(location, eventId).getOperationExecutionParams();
    }

    private <M extends ComponentModel> LocationSpecificSdkInternalContext<M> getLocationSpecificSdkInternalContext(ComponentLocation location, String eventId) {
        LocationSpecificSdkInternalContext locationSpecificSdkInternalContext = this.locationSpecificContext.get(new Pair((Object)location, (Object)eventId));
        if (locationSpecificSdkInternalContext == null) {
            String locationString = this.getLocationString(location);
            throw new NullPointerException("No Context at location - %s for event - %s".formatted(locationString, eventId));
        }
        return locationSpecificSdkInternalContext;
    }

    private String getLocationString(ComponentLocation location) {
        return location != null ? location.getLocation() : "null";
    }

    public Map<String, Object> getResolutionResult(ComponentLocation location, String eventId) {
        return this.locationSpecificContext.get(new Pair((Object)location, (Object)eventId)).getResolutionResult();
    }

    public void setResolutionResult(ComponentLocation location, String eventId, Map<String, Object> resolutionResult) {
        this.locationSpecificContext.get(new Pair((Object)location, (Object)eventId)).setResolutionResult(resolutionResult);
    }

    public OperationPolicy getPolicyToApply(ComponentLocation location, String eventId) {
        return this.locationSpecificContext.get(new Pair((Object)location, (Object)eventId)).getPolicyToApply();
    }

    public void setPolicyToApply(ComponentLocation location, String eventId, OperationPolicy policyToApply) {
        this.locationSpecificContext.get(new Pair((Object)location, (Object)eventId)).setPolicyToApply(policyToApply);
    }

    public boolean isNoPolicyOperation(ComponentLocation location, String eventId) {
        return DefaultPolicyManager.isNoPolicyOperation((OperationPolicy)this.getPolicyToApply(location, eventId));
    }

    public UnaryOperator<Context> getInnerChainSubscriberContextMapping() {
        return this.innerChainSubscriberContextMapping;
    }

    public void setInnerChainSubscriberContextMapping(UnaryOperator<Context> innerChainSubscriberContextMapping) {
        this.innerChainSubscriberContextMapping = innerChainSubscriberContextMapping;
    }

    public SdkInternalContext copy() {
        return this;
    }

    public static final class LocationSpecificSdkInternalContext<M extends ComponentModel> {
        private OperationExecutionParams<M> operationExecutionParams;
        private Optional<ConfigurationInstance> configuration = Optional.empty();
        private Map<String, Object> resolutionResult;
        private OperationPolicy policyToApply;

        public OperationExecutionParams<M> getOperationExecutionParams() {
            return this.operationExecutionParams;
        }

        public void setOperationExecutionParams(Optional<ConfigurationInstance> configuration, Map<String, Object> parameters, CoreEvent operationEvent, CompletableComponentExecutor.ExecutorCallback callback, ExecutionContextAdapter<M> executionContextAdapter) {
            this.operationExecutionParams = new OperationExecutionParams<M>(configuration, parameters, operationEvent, callback, executionContextAdapter);
        }

        public Optional<ConfigurationInstance> getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(Optional<ConfigurationInstance> configuration) {
            this.configuration = configuration;
        }

        public Map<String, Object> getResolutionResult() {
            return this.resolutionResult;
        }

        public void setResolutionResult(Map<String, Object> resolutionResult) {
            this.resolutionResult = resolutionResult;
        }

        public OperationPolicy getPolicyToApply() {
            return this.policyToApply;
        }

        public void setPolicyToApply(OperationPolicy policyToApply) {
            this.policyToApply = policyToApply;
        }
    }

    public record OperationExecutionParams<M extends ComponentModel>(Optional<ConfigurationInstance> configuration, Map<String, Object> parameters, CoreEvent operationEvent, CompletableComponentExecutor.ExecutorCallback callback, ExecutionContextAdapter<M> executionContextAdapter) {
    }
}

