/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.runtime.execution.interceptor.LinkedInterceptorChain;
import org.mule.runtime.module.extension.internal.runtime.execution.interceptor.NullInterceptorChain;

public interface InterceptorChain {
    public static Builder builder() {
        return new Builder();
    }

    public Throwable before(ExecutionContext var1, CompletableComponentExecutor.ExecutorCallback var2);

    public void onSuccess(ExecutionContext var1, Object var2);

    public Throwable onError(ExecutionContext var1, Throwable var2);

    public void abort(ExecutionContext var1);

    public static class Builder {
        private final List<Interceptor> interceptors = new ArrayList<Interceptor>(2);

        private Builder() {
        }

        public Builder addInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public InterceptorChain build() {
            return this.interceptors.isEmpty() ? NullInterceptorChain.INSTANCE : LinkedInterceptorChain.of(this.interceptors);
        }
    }
}

