/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.VariableElement;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.loader.util.InfrastructureTypeUtils;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureTypeResolver;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ClassBasedAnnotationValueFetcher;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.springframework.core.ResolvableType;

public class FieldWrapper
implements FieldElement {
    private final Field field;
    private final ClassTypeLoader typeLoader;
    private FieldSetter fieldSetter;

    public FieldWrapper(Field field, ClassTypeLoader typeLoader) {
        this.field = field;
        this.typeLoader = typeLoader;
    }

    @Override
    public Optional<Field> getField() {
        return Optional.ofNullable(this.field);
    }

    @Override
    public void set(Object object, Object value) {
        if (this.fieldSetter == null) {
            this.fieldSetter = new FieldSetter(this.field);
        }
        this.fieldSetter.set(object, value);
    }

    @Override
    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.field.getAnnotation(annotation) != null;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.field.getAnnotation(annotationClass));
    }

    @Override
    public TypeWrapper getType() {
        return new TypeWrapper(ResolvableType.forField(this.field), this.typeLoader);
    }

    @Override
    public String getAlias() {
        return InfrastructureTypeResolver.getInfrastructureType(this.getType()).map(InfrastructureTypeUtils.MetadataTypeBasedInfrastructureType::getName).orElse(FieldElement.super.getAlias());
    }

    @Override
    public String getOwnerDescription() {
        return String.format("Class: '%s'", this.field.getDeclaringClass().getSimpleName());
    }

    @Override
    public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
        return this.isAnnotatedWith(annotationClass) ? Optional.of(new ClassBasedAnnotationValueFetcher<A>(annotationClass, this.field, this.typeLoader)) : Optional.empty();
    }

    @Override
    public Stream<Type> getAnnotations() {
        return Arrays.stream(this.field.getAnnotations()).map(ann -> new TypeWrapper(ann.annotationType(), this.typeLoader));
    }

    @Override
    public Optional<VariableElement> getElement() {
        return Optional.empty();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldWrapper) {
            return Objects.equals(((FieldWrapper)obj).field, this.field);
        }
        return false;
    }

    public int hashCode() {
        return this.field.hashCode();
    }
}

