/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.source;

import java.util.function.Consumer;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.execution.FlowProcessTemplate;
import org.mule.runtime.core.internal.execution.MessageProcessContext;
import org.mule.runtime.core.internal.execution.MessageProcessingManager;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.extension.api.client.source.SourceResultHandler;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.internal.runtime.client.source.DefaultSourceResultHandler;
import org.mule.runtime.module.extension.internal.runtime.client.source.SourceClient;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionsFlowProcessingTemplate;
import org.mule.sdk.api.runtime.operation.Result;

class ExtensionsClientMessageProcessingManager<T, A>
implements MessageProcessingManager {
    private final SourceClient sourceClient;
    private final Consumer<SourceResultHandler<T, A>> handlerConsumer;

    ExtensionsClientMessageProcessingManager(SourceClient sourceClient, Consumer<SourceResultHandler<T, A>> handlerConsumer) {
        this.sourceClient = sourceClient;
        this.handlerConsumer = handlerConsumer;
    }

    public void processMessage(FlowProcessTemplate template, MessageProcessContext messageProcessContext) {
        Preconditions.checkArgument((boolean)(template instanceof ExtensionsFlowProcessingTemplate), (String)"invalid processing template");
        ExtensionsFlowProcessingTemplate process = (ExtensionsFlowProcessingTemplate)template;
        SourceResultAdapter resultAdapter = process.getSourceMessage();
        org.mule.runtime.extension.api.runtime.operation.Result<Object, Object> result = this.getResult(resultAdapter);
        this.handlerConsumer.accept(new DefaultSourceResultHandler<Object, Object>(this.sourceClient, result, process));
    }

    private org.mule.runtime.extension.api.runtime.operation.Result<Object, Object> getResult(SourceResultAdapter adapter) {
        Result sdkResult = adapter.getPayloadMediaTypeResolver().resolve(adapter.getResult());
        return (org.mule.runtime.extension.api.runtime.operation.Result)FunctionalUtils.withNullEvent(event -> {
            EventContext context = event.getContext();
            Result.Builder builder = org.mule.runtime.extension.api.runtime.operation.Result.builder().output(adapter.getCursorProviderFactory().of(context, sdkResult.getOutput(), context.getOriginatingLocation()));
            if (sdkResult.getMediaType().isPresent()) {
                builder.mediaType((MediaType)sdkResult.getMediaType().get());
            }
            sdkResult.getMediaType().ifPresent(arg_0 -> ((Result.Builder)builder).mediaType(arg_0));
            sdkResult.getAttributes().ifPresent(arg_0 -> ((Result.Builder)builder).attributes(arg_0));
            sdkResult.getAttributesMediaType().ifPresent(arg_0 -> ((Result.Builder)builder).attributesMediaType(arg_0));
            sdkResult.getByteLength().ifPresent(arg_0 -> ((Result.Builder)builder).length(arg_0));
            return builder.build();
        });
    }
}

