/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.source;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.client.source.SourceHandler;
import org.mule.runtime.module.extension.internal.runtime.client.source.SourceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSourceHandler
implements SourceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSourceHandler.class);
    private final SourceClient sourceClient;
    private final Runnable afterDisposeAction;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    public DefaultSourceHandler(SourceClient sourceClient, Runnable afterDisposeAction) {
        this.sourceClient = sourceClient;
        this.afterDisposeAction = afterDisposeAction;
    }

    public void start() throws MuleException {
        this.assertNotDisposed();
        if (this.started.compareAndSet(false, true)) {
            LifecycleUtils.startIfNeeded((Object)this.sourceClient);
        }
    }

    public void stop() throws MuleException {
        this.assertNotDisposed();
        if (this.started.compareAndSet(true, false)) {
            LifecycleUtils.stopIfNeeded((Object)this.sourceClient);
        }
    }

    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            LifecycleUtils.disposeIfNeeded((Object)this.sourceClient, (Logger)LOGGER);
            try {
                this.afterDisposeAction.run();
            }
            catch (Exception e) {
                LOGGER.error("Exception executing afterDisposeAction: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void assertNotDisposed() {
        Preconditions.checkState((!this.disposed.get() ? 1 : 0) != 0, (String)"This source has already been disposed");
    }
}

