/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ExpressionBasedParameterResolverValueResolver<T>
implements ExpressionBasedValueResolver<ParameterResolver<T>>,
Initialisable {
    private final String expression;
    private final DataType expectedDataType;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;
    @Inject
    private MuleContext muleContext;
    @Inject
    private Registry registry;
    private Class<T> type;
    private boolean melDefault;
    private boolean melAvailable;
    private TypeSafeExpressionValueResolver<T> delegateResolver;

    public ExpressionBasedParameterResolverValueResolver(String expression, Class<T> type, DataType expectedDataType) {
        this.expression = expression;
        this.type = type;
        this.expectedDataType = expectedDataType;
    }

    public void initialise() throws InitialisationException {
        this.melDefault = Boolean.valueOf(System.getProperty("mule.test.mel.default", "false"));
        this.melAvailable = this.registry.lookupByName("_compatibilityPluginInstalled").isPresent();
        this.delegateResolver = new TypeSafeExpressionValueResolver<T>(this.expression, this.type, this.expectedDataType);
        this.delegateResolver.setExtendedExpressionManager(this.extendedExpressionManager);
        this.delegateResolver.setTransformationService(this.transformationService);
        this.delegateResolver.setMuleContext(this.muleContext);
        this.delegateResolver.setMelDefault(this.melDefault);
        this.delegateResolver.setMelAvailable(this.melAvailable);
        this.delegateResolver.initialise();
    }

    @Override
    public ParameterResolver<T> resolve(ValueResolvingContext context) throws MuleException {
        return new ExpressionBasedParameterResolver<T>(this.expression, this.delegateResolver, context);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    public void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }
}

