/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ParameterizableTypeElement;
import org.mule.runtime.module.extension.internal.loader.java.info.ExtensionInfo;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ClassBasedAnnotationValueFetcher;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ComponentWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ConfigurationWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FunctionWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.utils.AnnotationsIntrospectorUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.Extension;

public class ExtensionTypeWrapper<T>
extends ComponentWrapper
implements ExtensionElement,
ParameterizableTypeElement {
    private final LazyValue<ExtensionInfo> extensionInfo;
    private final boolean needsAnnotationIntrospection;
    private final LazyValue<Map<Class<? extends Annotation>, Annotation>> annotations;

    public ExtensionTypeWrapper(Class<T> aClass, ClassTypeLoader typeLoader) {
        super(aClass, ExtensionTypeWrapper.newCachedClassTypeLoader(typeLoader));
        this.needsAnnotationIntrospection = this.needsAnnotationIntrospection(aClass);
        this.annotations = new LazyValue(() -> AnnotationsIntrospectorUtils.extractAnnotations(aClass));
        this.extensionInfo = new LazyValue(() -> this.needsAnnotationIntrospection ? MuleExtensionAnnotationParser.getExtensionInfo(this.getAnnotation(org.mule.runtime.extension.api.annotation.Extension.class).orElse(null), this.getAnnotation(Extension.class).orElse(null), aClass.getName()) : MuleExtensionAnnotationParser.getExtensionInfo(aClass));
    }

    private boolean needsAnnotationIntrospection(Class<T> aClass) {
        try {
            aClass.getAnnotations();
            return false;
        }
        catch (ArrayStoreException e) {
            return true;
        }
    }

    @Override
    protected <A extends Annotation> AnnotationValueFetcher<A> getClassBasedAnnotationValueFetcher(Class<A> annotationClass, Class<?> aClass, ClassTypeLoader typeLoader) {
        if (!this.needsAnnotationIntrospection) {
            return super.getClassBasedAnnotationValueFetcher(annotationClass, aClass, typeLoader);
        }
        return new ClassBasedAnnotationValueFetcher<Annotation>((Annotation)((Map)this.annotations.get()).get(annotationClass), typeLoader);
    }

    @Override
    protected <A extends Annotation> A getAnnotationFromClass(Class<A> annotation) {
        if (!this.needsAnnotationIntrospection) {
            return super.getAnnotationFromClass(annotation);
        }
        return (A)((Annotation)((Map)this.annotations.get()).get(annotation));
    }

    @Override
    protected Annotation[] getAnnotationsFromClass() {
        if (!this.needsAnnotationIntrospection) {
            return super.getAnnotationsFromClass();
        }
        return ((Map)this.annotations.get()).values().toArray(new Annotation[((Map)this.annotations.get()).size()]);
    }

    private static ClassTypeLoader newCachedClassTypeLoader(ClassTypeLoader classTypeLoader) {
        return new CachedClassTypeLoader(classTypeLoader);
    }

    @Override
    public List<ConfigurationElement> getConfigurations() {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this, Configurations.class, org.mule.sdk.api.annotation.Configurations.class, value -> value.getClassArrayValue(Configurations::value), value -> value.getClassArrayValue(org.mule.sdk.api.annotation.Configurations::value)).map(types -> types.stream().map(type -> new ConfigurationWrapper((Class)type.getDeclaringClass().get(), this.typeLoader)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public List<OperationElement> getOperations() {
        return this.getOperationClassStream().flatMap(clazz -> IntrospectionUtils.getApiMethods(clazz).stream()).map(clazz -> new OperationWrapper((Method)clazz, this.typeLoader)).collect(Collectors.toList());
    }

    @Override
    public List<FunctionElement> getFunctions() {
        return this.getExpressionFunctionClassStream().flatMap(clazz -> IntrospectionUtils.getApiMethods(clazz).stream()).map(clazz -> new FunctionWrapper((Method)clazz, this.typeLoader)).collect(Collectors.toList());
    }

    @Override
    public Category getCategory() {
        return ((ExtensionInfo)this.extensionInfo.get()).getCategory();
    }

    @Override
    public String getVendor() {
        return ((ExtensionInfo)this.extensionInfo.get()).getVendor();
    }

    @Override
    public String getName() {
        return ((ExtensionInfo)this.extensionInfo.get()).getName();
    }

    private static class CachedClassTypeLoader
    implements ClassTypeLoader {
        private ClassTypeLoader classTypeLoader;
        private Map<Type, MetadataType> typeMetadataTypeMap = new WeakHashMap<Type, MetadataType>();
        private Map<String, Optional<MetadataType>> typeIdentifierMetadataTypeMap = new WeakHashMap<String, Optional<MetadataType>>();

        public CachedClassTypeLoader(ClassTypeLoader classTypeLoader) {
            Objects.requireNonNull(classTypeLoader, "classTypeLoader cannot be null");
            this.classTypeLoader = classTypeLoader;
        }

        public MetadataType load(Type type) {
            return this.typeMetadataTypeMap.computeIfAbsent(type, k -> this.classTypeLoader.load(type));
        }

        public ClassLoader getClassLoader() {
            return this.classTypeLoader.getClassLoader();
        }

        public Optional<MetadataType> load(String typeIdentifier) {
            return this.typeIdentifierMetadataTypeMap.computeIfAbsent(typeIdentifier, k -> this.classTypeLoader.load(k));
        }
    }
}

