/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.internal.loader.util.JavaParserUtils;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.info.ExtensionInfo;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.param.display.Placement;
import org.mule.sdk.api.annotation.semantics.security.Password;
import org.mule.sdk.api.meta.Category;

public final class MuleExtensionAnnotationParser {
    public static String getMemberName(BaseDeclaration<?> declaration, String defaultName) {
        return declaration.getModelProperty(DeclaringMemberModelProperty.class).map(p -> p.getDeclaringField().getName()).orElse(defaultName);
    }

    public static ExtensionInfo getExtensionInfo(Class<?> extensionType) {
        return MuleExtensionAnnotationParser.getExtensionInfo(extensionType.getAnnotation(org.mule.runtime.extension.api.annotation.Extension.class), extensionType.getAnnotation(Extension.class), extensionType.getName());
    }

    public static ExtensionInfo getExtensionInfo(org.mule.runtime.extension.api.annotation.Extension legacy, Extension extension, String extensionName) {
        if (legacy != null) {
            return new ExtensionInfo(legacy.name(), legacy.vendor(), legacy.category());
        }
        if (extension != null) {
            return new ExtensionInfo(extension.name(), extension.vendor(), JavaParserUtils.toMuleApi((Category)extension.category()));
        }
        throw new IllegalModelDefinitionException(String.format("Class '%s' not annotated with neither '%s' nor '%s'", extensionName, org.mule.runtime.extension.api.annotation.Extension.class.getName(), Extension.class.getName()));
    }

    public static <L extends Annotation, A extends Annotation, T> Stream<T> mapReduceRepeatableAnnotation(WithAnnotations element, Class<L> legacyAnnotationType, Class<A> sdkApiAnnotationType, Function<Annotation, L[]> legacyContainerMapping, Function<Annotation, A[]> sdkApiContainerMapping, Function<AnnotationValueFetcher<L>, T> legacyMapping, Function<AnnotationValueFetcher<A>, T> sdkApiMapping) {
        return Stream.concat(MuleExtensionAnnotationParser.mapReduceRepeatableAnnotation(element, legacyAnnotationType, legacyContainerMapping).map(legacyMapping), MuleExtensionAnnotationParser.mapReduceRepeatableAnnotation(element, sdkApiAnnotationType, sdkApiContainerMapping).map(sdkApiMapping));
    }

    public static <T extends Annotation> Stream<AnnotationValueFetcher<T>> mapReduceRepeatableAnnotation(WithAnnotations element, Class<T> annotation, Function<Annotation, T[]> containerMapper) {
        Stream<AnnotationValueFetcher<T>> singleElementStream = MuleExtensionAnnotationParser.getAnnotationFromHierarchy(element, annotation).map(Stream::of).orElse(Stream.empty());
        Repeatable repeatableContainer = annotation.getAnnotation(Repeatable.class);
        if (repeatableContainer != null) {
            Stream containerStream = MuleExtensionAnnotationParser.getAnnotationFromHierarchy(element, repeatableContainer.value()).map(container -> container.getInnerAnnotations(containerMapper).stream()).orElse(Stream.empty());
            return Stream.concat(singleElementStream, containerStream);
        }
        return singleElementStream;
    }

    private static <T extends Annotation> Optional<AnnotationValueFetcher<T>> getAnnotationFromHierarchy(WithAnnotations element, Class<T> annotation) {
        Optional<AnnotationValueFetcher<T>> valueFetcher = element.getValueFromAnnotation(annotation);
        if (valueFetcher.isPresent()) {
            return valueFetcher;
        }
        if (element instanceof Type) {
            return ((Type)element).getSuperType().flatMap(superType -> MuleExtensionAnnotationParser.getAnnotationFromHierarchy(superType, annotation));
        }
        return Optional.empty();
    }

    public static List<String> getParamNames(Method method) {
        return Stream.of(method.getParameters()).map(parameter -> JavaParserUtils.getAlias((AnnotatedElement)parameter, parameter::getName)).collect(Collectors.toList());
    }

    public static Map<Class<? extends Annotation>, Annotation> toMap(Annotation[] annotations) {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            map.put(ClassUtils.resolveAnnotationClass((Annotation)annotation), annotation);
        }
        return map;
    }

    private static void doParseLayoutAnnotations(AnnotatedElement annotatedElement, LayoutModel.LayoutModelBuilder builder) {
        Text textAnnotation;
        if (annotatedElement.getAnnotation(org.mule.runtime.extension.api.annotation.param.display.Password.class) != null || annotatedElement.getAnnotation(Password.class) != null) {
            builder.asPassword();
        }
        if ((textAnnotation = annotatedElement.getAnnotation(Text.class)) != null) {
            builder.asText();
        }
    }

    private static void doParseLayoutAnnotations(WithAnnotations annotatedElement, LayoutModel.LayoutModelBuilder builder, String elementName) {
        if (annotatedElement.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.display.Password.class) || annotatedElement.isAnnotatedWith(Password.class)) {
            builder.asPassword();
        }
        boolean legacyTextAnnotationPresent = annotatedElement.isAnnotatedWith(Text.class);
        boolean sdkTextAnnotationPresent = annotatedElement.isAnnotatedWith(org.mule.sdk.api.annotation.param.display.Text.class);
        if (legacyTextAnnotationPresent && sdkTextAnnotationPresent) {
            throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' and '@%s' at the same time", elementName, Text.class.getName(), org.mule.sdk.api.annotation.param.display.Text.class.getName()));
        }
        if (legacyTextAnnotationPresent || sdkTextAnnotationPresent) {
            builder.asText();
        }
    }

    private static void parsePlacementAnnotation(WithAnnotations annotatedElement, LayoutModel.LayoutModelBuilder builder, String elementName) {
        Optional<AnnotationValueFetcher<org.mule.runtime.extension.api.annotation.param.display.Placement>> legacyPlacementAnnotation = annotatedElement.getValueFromAnnotation(org.mule.runtime.extension.api.annotation.param.display.Placement.class);
        Optional<AnnotationValueFetcher<Placement>> sdkPlacementAnnotation = annotatedElement.getValueFromAnnotation(Placement.class);
        if (legacyPlacementAnnotation.isPresent() && sdkPlacementAnnotation.isPresent()) {
            throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' and '@%s' at the same time", elementName, org.mule.runtime.extension.api.annotation.param.display.Placement.class.getName(), Placement.class.getName()));
        }
        if (legacyPlacementAnnotation.isPresent()) {
            int order = legacyPlacementAnnotation.get().getNumberValue(org.mule.runtime.extension.api.annotation.param.display.Placement::order);
            String tab = legacyPlacementAnnotation.get().getStringValue(org.mule.runtime.extension.api.annotation.param.display.Placement::tab);
            builder.order(order).tabName(tab);
        } else if (sdkPlacementAnnotation.isPresent()) {
            int order = sdkPlacementAnnotation.get().getNumberValue(Placement::order);
            String tab = sdkPlacementAnnotation.get().getStringValue(Placement::tab);
            builder.order(order).tabName(tab);
        }
    }

    private static void parsePlacementAnnotation(AnnotatedElement annotatedElement, LayoutModel.LayoutModelBuilder builder, String elementName) {
        org.mule.runtime.extension.api.annotation.param.display.Placement legacyPlacementAnnotation = annotatedElement.getAnnotation(org.mule.runtime.extension.api.annotation.param.display.Placement.class);
        Placement sdkPlacementAnnotation = annotatedElement.getAnnotation(Placement.class);
        if (legacyPlacementAnnotation != null && sdkPlacementAnnotation != null) {
            throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' and '@%s' at the same time", elementName, org.mule.runtime.extension.api.annotation.param.display.Placement.class.getName(), Placement.class.getName()));
        }
        if (legacyPlacementAnnotation != null) {
            int order = legacyPlacementAnnotation.order();
            String tab = legacyPlacementAnnotation.tab();
            builder.order(order).tabName(tab);
        } else if (sdkPlacementAnnotation != null) {
            int order = sdkPlacementAnnotation.order();
            String tab = sdkPlacementAnnotation.tab();
            builder.order(order).tabName(tab);
        }
    }

    public static Optional<LayoutModel> parseLayoutAnnotations(AnnotatedElement annotatedElement, String elementName) {
        return MuleExtensionAnnotationParser.parseLayoutAnnotations(annotatedElement, LayoutModel.builder(), elementName);
    }

    public static Optional<LayoutModel> parseLayoutAnnotations(WithAnnotations annotatedElement, String elementName) {
        return MuleExtensionAnnotationParser.parseLayoutAnnotations(annotatedElement, LayoutModel.builder(), elementName);
    }

    public static Optional<LayoutModel> parseLayoutAnnotations(WithAnnotations annotatedElement, LayoutModel.LayoutModelBuilder builder, String elementName) {
        if (MuleExtensionAnnotationParser.isDisplayAnnotationPresent(annotatedElement)) {
            MuleExtensionAnnotationParser.doParseLayoutAnnotations(annotatedElement, builder, elementName);
            MuleExtensionAnnotationParser.parsePlacementAnnotation(annotatedElement, builder, elementName);
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    public static Optional<LayoutModel> parseLayoutAnnotations(AnnotatedElement annotatedElement, LayoutModel.LayoutModelBuilder builder, String elementName) {
        if (MuleExtensionAnnotationParser.isDisplayAnnotationPresent(annotatedElement)) {
            MuleExtensionAnnotationParser.doParseLayoutAnnotations(annotatedElement, builder);
            MuleExtensionAnnotationParser.parsePlacementAnnotation(annotatedElement, builder, elementName);
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    private static boolean isDisplayAnnotationPresent(AnnotatedElement annotatedElement) {
        List<Class> displayAnnotations = Arrays.asList(org.mule.runtime.extension.api.annotation.param.display.Password.class, Text.class, org.mule.runtime.extension.api.annotation.param.display.Placement.class, org.mule.sdk.api.annotation.param.display.Text.class, Placement.class, Password.class);
        return displayAnnotations.stream().anyMatch(annotation -> annotatedElement.getAnnotation(annotation) != null);
    }

    private static boolean isDisplayAnnotationPresent(WithAnnotations annotatedElement) {
        List<Class> displayAnnotations = Arrays.asList(org.mule.runtime.extension.api.annotation.param.display.Password.class, Text.class, org.mule.runtime.extension.api.annotation.param.display.Placement.class, org.mule.sdk.api.annotation.param.display.Text.class, Placement.class, Password.class);
        return displayAnnotations.stream().anyMatch(annotation -> annotatedElement.isAnnotatedWith((Class<? extends Annotation>)annotation));
    }

    public static <R extends Annotation, S extends Annotation, T> Optional<T> mapReduceSingleAnnotation(ExtensionElement extensionElement, Class<R> legacyAnnotationClass, Class<S> sdkAnnotationClass, Function<AnnotationValueFetcher<R>, T> legacyAnnotationMapping, Function<AnnotationValueFetcher<S>, T> sdkAnnotationMapping) {
        return MuleExtensionAnnotationParser.mapReduceAnnotation(extensionElement, legacyAnnotationClass, sdkAnnotationClass, legacyAnnotationMapping, sdkAnnotationMapping, () -> new IllegalParameterModelDefinitionException(String.format("Extension '%s' is annotated with '@%s' and '@%s' at the same time", extensionElement.getName(), legacyAnnotationClass.getName(), sdkAnnotationClass.getName())));
    }

    public static <R extends Annotation, S extends Annotation, T> Optional<T> mapReduceSingleAnnotation(WithAnnotations element, String elementType, String elementName, Class<R> legacyAnnotationClass, Class<S> sdkAnnotationClass, Function<AnnotationValueFetcher<R>, T> legacyAnnotationMapping, Function<AnnotationValueFetcher<S>, T> sdkAnnotationMapping) {
        return MuleExtensionAnnotationParser.mapReduceAnnotation(element, legacyAnnotationClass, sdkAnnotationClass, legacyAnnotationMapping, sdkAnnotationMapping, () -> new IllegalParameterModelDefinitionException(String.format("Annotations %s and %s are both present at the same time on %s %s", legacyAnnotationClass.getName(), sdkAnnotationClass.getName(), elementType, elementName)));
    }

    public static <R extends Annotation, S extends Annotation, T> Optional<T> mapReduceAnnotation(WithAnnotations element, Class<R> legacyAnnotationClass, Class<S> sdkAnnotationClass, Function<AnnotationValueFetcher<R>, T> legacyAnnotationMapping, Function<AnnotationValueFetcher<S>, T> sdkAnnotationMapping, Supplier<? extends IllegalModelDefinitionException> dualDefinitionExceptionFactory) {
        Optional<AnnotationValueFetcher<R>> legacyAnnotation = element.getValueFromAnnotation(legacyAnnotationClass);
        Optional<AnnotationValueFetcher<S>> sdkAnnotation = element.getValueFromAnnotation(sdkAnnotationClass);
        if (legacyAnnotation.isPresent() && sdkAnnotation.isPresent()) {
            throw dualDefinitionExceptionFactory.get();
        }
        if (legacyAnnotation.isPresent()) {
            return legacyAnnotation.map(legacyAnnotationMapping);
        }
        if (sdkAnnotation.isPresent()) {
            return sdkAnnotation.map(sdkAnnotationMapping);
        }
        if (element instanceof Type) {
            return ((Type)element).getSuperType().flatMap(superType -> MuleExtensionAnnotationParser.mapReduceAnnotation(superType, legacyAnnotationClass, sdkAnnotationClass, legacyAnnotationMapping, sdkAnnotationMapping, dualDefinitionExceptionFactory));
        }
        return Optional.empty();
    }
}

