/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.util;

import java.util.Collections;
import java.util.Map;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManager;

public class MuleExtensionUtils {
    private MuleExtensionUtils() {
    }

    public static ExtensionModel loadExtension(Class<?> clazz) {
        return MuleExtensionUtils.loadExtension(clazz, (Map<String, Object>)new SmallMap());
    }

    public static ExtensionModel loadExtension(Class<?> clazz, Map<String, Object> params) {
        params.put("type", clazz.getName());
        params.put("version", MuleManifest.getProductVersion());
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(Collections.singleton(MuleExtensionModelProvider.getExtensionModel()));
        return new DefaultJavaExtensionModelLoader().loadExtensionModel(clazz.getClassLoader(), dslResolvingContext, params);
    }

    @Deprecated
    public static CoreEvent getInitialiserEvent() {
        return NullEventFactory.getNullEvent();
    }

    @Deprecated
    public static CoreEvent getInitialiserEvent(MuleContext muleContext) {
        return NullEventFactory.getNullEvent((MuleContext)muleContext);
    }

    public static ExtensionManager createDefaultExtensionManager() {
        return new DefaultExtensionManager();
    }

    public static boolean isIgnoreDisabled(ExtensionLoadingContext loadingContext) {
        return loadingContext.getParameter("EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE").map(v -> v instanceof Boolean ? (Boolean)v : false).orElse(false);
    }

    public static boolean isPollingSourceLimitEnabled(ExtensionLoadingContext loadingContext) {
        return loadingContext.getParameter("EXTENSION_LOADER_ENABLE_POLLING_SOURCE_LIMIT").map(v -> v instanceof Boolean ? (Boolean)v : false).orElse(false);
    }
}

