/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client;

import com.google.common.util.concurrent.ForwardingExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

final class ShutdownExecutor
extends ForwardingExecutorService {
    private final AtomicInteger tasks = new AtomicInteger();
    private final Semaphore semaphore = new Semaphore(0);
    private volatile boolean shutdown;

    ShutdownExecutor() {
    }

    public void execute(Runnable task) {
        if (this.shutdown) {
            throw new RejectedExecutionException("Shutdown");
        }
        this.tasks.incrementAndGet();
        this.delegate().execute(() -> {
            try {
                task.run();
            }
            finally {
                this.semaphore.release();
            }
        });
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        int permits = this.tasks.get();
        boolean terminated = this.semaphore.tryAcquire(permits, timeout, unit);
        if (terminated) {
            this.semaphore.release(permits);
        }
        return terminated && this.shutdown;
    }

    public boolean isTerminated() {
        try {
            return this.awaitTermination(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected ExecutorService delegate() {
        return ForkJoinPool.commonPool();
    }
}

