/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ConfigurationProviderValueResolver
implements ValueResolver<ConfigurationProvider>,
Initialisable,
MuleContextAware {
    private final ValueResolver<String> configurationProviderNameResolver;
    private MuleContext muleContext;
    private ConfigurationProvider cachedConfigurationProvider;

    public ConfigurationProviderValueResolver(String configurationProviderReference) {
        this.configurationProviderNameResolver = MuleExtensionUtils.isExpression(configurationProviderReference) ? new TypeSafeExpressionValueResolver<String>(configurationProviderReference, String.class, DataType.STRING) : new StaticValueResolver<String>(configurationProviderReference);
    }

    @Override
    public ConfigurationProvider resolve(ValueResolvingContext context) throws MuleException {
        if (this.cachedConfigurationProvider != null) {
            return this.cachedConfigurationProvider;
        }
        ConfigurationProvider configurationProvider = this.doResolve(context);
        if (!this.isDynamic()) {
            this.cachedConfigurationProvider = configurationProvider;
        }
        return configurationProvider;
    }

    private ConfigurationProvider doResolve(ValueResolvingContext context) throws MuleException {
        String configurationProviderName = this.configurationProviderNameResolver.resolve(context);
        return (ConfigurationProvider)this.muleContext.getExtensionManager().getConfigurationProvider(configurationProviderName).orElseThrow(() -> new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("There is no registered configurationProvider under name '%s'", configurationProviderName))));
    }

    @Override
    public boolean isDynamic() {
        return this.configurationProviderNameResolver.isDynamic();
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.configurationProviderNameResolver, (boolean)true, (MuleContext)this.muleContext);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

